/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class BasicTextUI
extends TextUI
implements ViewFactory {
    private static final EditorKit defaultKit = new DefaultEditorKit();
    transient JTextComponent editor;
    transient boolean painted = false;
    transient RootView rootView = new RootView();
    transient UpdateHandler updateHandler = new UpdateHandler();

    public View create(Element element) {
        return null;
    }

    public View create(Element element, int n, int n2) {
        return null;
    }

    protected Caret createCaret() {
        return new BasicCaret();
    }

    protected Highlighter createHighlighter() {
        return new BasicHighlighter();
    }

    protected Keymap createKeymap() {
        String string = this.getKeymapName();
        Keymap keymap = JTextComponent.getKeymap(string);
        if (keymap == null) {
            Keymap keymap2 = JTextComponent.getKeymap("default");
            keymap = JTextComponent.addKeymap(string, keymap2);
            String string2 = this.getPropertyPrefix();
            Object object = UIManager.get(String.valueOf(string2) + ".keyBindings");
            if (object != null && object instanceof JTextComponent.KeyBinding[]) {
                JTextComponent.KeyBinding[] keyBindingArray = (JTextComponent.KeyBinding[])object;
                JTextComponent.loadKeymap(keymap, keyBindingArray, this.getComponent().getActions());
            }
        }
        return keymap;
    }

    public void damageRange(JTextComponent jTextComponent, int n, int n2) {
        this.damageRange(jTextComponent, n, n2, Position.Bias.Forward, Position.Bias.Backward);
    }

    public void damageRange(JTextComponent jTextComponent, int n, int n2, Position.Bias bias, Position.Bias bias2) {
        if (this.painted) {
            Rectangle rectangle = this.getVisibleEditorRect();
            Document document = jTextComponent.getDocument();
            try {
                try {
                    Shape shape;
                    if (document instanceof AbstractDocument) {
                        ((AbstractDocument)document).readLock();
                    }
                    Rectangle rectangle2 = (shape = this.rootView.modelToView(n, bias, n2, bias2, rectangle)) instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                    this.editor.repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                catch (BadLocationException badLocationException) {
                }
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
                throw throwable;
            }
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
    }

    protected final JTextComponent getComponent() {
        return this.editor;
    }

    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        return defaultKit;
    }

    protected String getKeymapName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1, string.length());
        }
        return string;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension();
        try {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            dimension.width = (int)Math.min((long)this.rootView.getMaximumSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
            dimension.height = (int)Math.min((long)this.rootView.getMaximumSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        }
        finally {
            Object var6_5 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension();
        try {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            dimension.width = (int)this.rootView.getMinimumSpan(0) + insets.left + insets.right;
            dimension.height = (int)this.rootView.getMinimumSpan(1) + insets.top + insets.bottom;
        }
        finally {
            Object var6_5 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return dimension;
    }

    public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
        if (this.painted) {
            Rectangle rectangle = this.getVisibleEditorRect();
            return this.rootView.getNextVisualPositionFrom(n, bias, rectangle, n2, biasArray);
        }
        return -1;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = jComponent.getSize();
        try {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            if (dimension.width > insets.left + insets.right && dimension.height > insets.top + insets.bottom) {
                this.rootView.setSize(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
            }
            dimension.width = (int)Math.min((long)this.rootView.getPreferredSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
            dimension.height = (int)Math.min((long)this.rootView.getPreferredSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        }
        finally {
            Object var6_5 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return dimension;
    }

    protected abstract String getPropertyPrefix();

    public View getRootView(JTextComponent jTextComponent) {
        return this.rootView;
    }

    protected Rectangle getVisibleEditorRect() {
        Rectangle rectangle = new Rectangle(this.editor.getSize());
        Insets insets = this.editor.getInsets();
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        return rectangle;
    }

    protected void installDefaults() {
        Object object;
        Caret caret;
        Insets insets;
        Border border;
        Color color;
        Color color2;
        Color color3;
        Color color4;
        Color color5;
        Color color6;
        String string = this.getPropertyPrefix();
        Font font = this.editor.getFont();
        if (font == null || font instanceof UIResource) {
            this.editor.setFont(UIManager.getFont(String.valueOf(string) + ".font"));
        }
        if ((color6 = this.editor.getBackground()) == null || color6 instanceof UIResource) {
            this.editor.setBackground(UIManager.getColor(String.valueOf(string) + ".background"));
        }
        if ((color5 = this.editor.getForeground()) == null || color5 instanceof UIResource) {
            this.editor.setForeground(UIManager.getColor(String.valueOf(string) + ".foreground"));
        }
        if ((color4 = this.editor.getCaretColor()) == null || color4 instanceof UIResource) {
            this.editor.setCaretColor(UIManager.getColor(String.valueOf(string) + ".caretForeground"));
        }
        if ((color3 = this.editor.getSelectionColor()) == null || color3 instanceof UIResource) {
            this.editor.setSelectionColor(UIManager.getColor(String.valueOf(string) + ".selectionBackground"));
        }
        if ((color2 = this.editor.getSelectedTextColor()) == null || color2 instanceof UIResource) {
            this.editor.setSelectedTextColor(UIManager.getColor(String.valueOf(string) + ".selectionForeground"));
        }
        if ((color = this.editor.getDisabledTextColor()) == null || color instanceof UIResource) {
            this.editor.setDisabledTextColor(UIManager.getColor(String.valueOf(string) + ".inactiveForeground"));
        }
        if ((border = this.editor.getBorder()) == null || border instanceof UIResource) {
            this.editor.setBorder(UIManager.getBorder(String.valueOf(string) + ".border"));
        }
        if ((insets = this.editor.getMargin()) == null || insets instanceof UIResource) {
            this.editor.setMargin(UIManager.getInsets(String.valueOf(string) + ".margin"));
        }
        if ((caret = this.editor.getCaret()) == null || caret instanceof UIResource) {
            caret = this.createCaret();
            this.editor.setCaret(caret);
            object = UIManager.get(String.valueOf(string) + ".caretBlinkRate");
            if (object != null && object instanceof Integer) {
                Integer n = (Integer)object;
                caret.setBlinkRate(n);
            }
        }
        if ((object = this.editor.getHighlighter()) == null || object instanceof UIResource) {
            this.editor.setHighlighter(this.createHighlighter());
        }
    }

    protected void installKeyboardActions() {
        this.editor.setKeymap(this.createKeymap());
    }

    protected void installListeners() {
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JTextComponent) {
            this.editor = (JTextComponent)jComponent;
            this.installDefaults();
            this.editor.setOpaque(true);
            this.editor.setAutoscrolls(true);
            this.editor.addPropertyChangeListener(this.updateHandler);
            Document document = this.editor.getDocument();
            if (document == null) {
                this.editor.setDocument(this.getEditorKit(this.editor).createDefaultDocument());
            } else {
                document.addDocumentListener(this.updateHandler);
                this.modelChanged();
            }
        } else {
            throw new Error("TextUI needs JTextComponent");
        }
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void modelChanged() {
        ViewFactory viewFactory = this.rootView.getViewFactory();
        Document document = this.editor.getDocument();
        Element element = document.getDefaultRootElement();
        this.setView(viewFactory.create(element));
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n) throws BadLocationException {
        Shape shape;
        Document document;
        block5: {
            document = this.editor.getDocument();
            shape = null;
            try {
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readLock();
                }
                if (!this.painted) break block5;
                Rectangle rectangle = this.getVisibleEditorRect();
                shape = this.rootView.modelToView(n, rectangle);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
                throw throwable;
            }
        }
        Object var6_6 = null;
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        return (Rectangle)shape;
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n, Position.Bias bias) throws BadLocationException {
        if (this.painted) {
            Rectangle rectangle = this.getVisibleEditorRect();
            Shape shape = this.rootView.modelToView(n, rectangle, bias);
            return shape.getBounds();
        }
        return null;
    }

    public final void paint(Graphics graphics, JComponent jComponent) {
        if (this.rootView.getViewCount() > 0 && this.rootView.getView(0) != null) {
            SafePainter safePainter = new SafePainter(graphics);
            Document document = this.editor.getDocument();
            document.render(safePainter);
        }
    }

    protected void paintBackground(Graphics graphics) {
        graphics.setColor(this.editor.getBackground());
        Dimension dimension = this.editor.getSize();
        graphics.fillRect(0, 0, dimension.width, dimension.height);
    }

    protected void paintSafely(Graphics graphics) {
        this.painted = true;
        Highlighter highlighter = this.editor.getHighlighter();
        Caret caret = this.editor.getCaret();
        if (this.editor.isOpaque()) {
            this.paintBackground(graphics);
        }
        if (highlighter != null) {
            highlighter.paint(graphics);
        }
        Rectangle rectangle = this.getVisibleEditorRect();
        this.rootView.paint(graphics, rectangle);
        if (caret != null) {
            caret.paint(graphics);
        }
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    protected final void setView(View view) {
        this.editor.removeAll();
        this.rootView.setView(view);
        this.painted = false;
        this.editor.revalidate();
    }

    protected void uninstallDefaults() {
        if (this.editor.getCaretColor() instanceof UIResource) {
            this.editor.setCaretColor(null);
        }
        if (this.editor.getSelectionColor() instanceof UIResource) {
            this.editor.setSelectionColor(null);
        }
        if (this.editor.getDisabledTextColor() instanceof UIResource) {
            this.editor.setDisabledTextColor(null);
        }
        if (this.editor.getSelectedTextColor() instanceof UIResource) {
            this.editor.setSelectedTextColor(null);
        }
        if (this.editor.getBorder() instanceof UIResource) {
            this.editor.setBorder(null);
        }
        if (this.editor.getMargin() instanceof UIResource) {
            this.editor.setMargin(null);
        }
        if (this.editor.getCaret() instanceof UIResource) {
            this.editor.setCaret(null);
        }
        if (this.editor.getHighlighter() instanceof UIResource) {
            this.editor.setHighlighter(null);
        }
    }

    protected void uninstallKeyboardActions() {
        this.editor.setKeymap(null);
    }

    protected void uninstallListeners() {
    }

    public void uninstallUI(JComponent jComponent) {
        this.editor.removePropertyChangeListener(this.updateHandler);
        this.editor.getDocument().removeDocumentListener(this.updateHandler);
        this.painted = false;
        this.uninstallDefaults();
        this.rootView.setView(null);
        jComponent.removeAll();
        this.uninstallKeyboardActions();
        this.uninstallListeners();
    }

    public int viewToModel(JTextComponent jTextComponent, Point point) {
        Document document;
        int n;
        block5: {
            n = -1;
            document = this.editor.getDocument();
            try {
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readLock();
                }
                if (!this.painted) break block5;
                Rectangle rectangle = this.getVisibleEditorRect();
                n = this.rootView.viewToModel(point.x, point.y, rectangle);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
                throw throwable;
            }
        }
        Object var6_6 = null;
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        return n;
    }

    public int viewToModel(JTextComponent jTextComponent, Point point, Position.Bias[] biasArray) {
        if (this.painted) {
            Rectangle rectangle = this.getVisibleEditorRect();
            return this.rootView.viewToModel(point.x, point.y, rectangle, biasArray);
        }
        return -1;
    }

    public static class BasicCaret
    extends DefaultCaret
    implements UIResource {
    }

    public static class BasicHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    class RootView
    extends View {
        private View view;

        RootView() {
            super(null);
        }

        public View breakView(int n, float f, Shape shape) {
            throw new Error("Can't break root view");
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.changedUpdate(documentEvent, shape, viewFactory);
            }
        }

        public float getAlignment(int n) {
            if (this.view != null) {
                return this.view.getAlignment(n);
            }
            return 0.0f;
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public Shape getChildAllocation(int n, Shape shape) {
            return shape;
        }

        public Container getContainer() {
            return BasicTextUI.this.editor;
        }

        public Document getDocument() {
            return BasicTextUI.this.editor.getDocument();
        }

        public Element getElement() {
            if (this.view != null) {
                return this.view.getElement();
            }
            return BasicTextUI.this.editor.getDocument().getDefaultRootElement();
        }

        public int getEndOffset() {
            if (this.view != null) {
                return this.view.getEndOffset();
            }
            return this.getElement().getEndOffset();
        }

        public float getMaximumSpan(int n) {
            return 2.1474836E9f;
        }

        public float getMinimumSpan(int n) {
            if (this.view != null) {
                return this.view.getMinimumSpan(n);
            }
            return 10.0f;
        }

        public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            if (this.view != null) {
                int n3 = this.view.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
                if (n3 != -1) {
                    n = n3;
                } else {
                    biasArray[0] = bias;
                }
            }
            return n;
        }

        public float getPreferredSpan(int n) {
            if (this.view != null) {
                return this.view.getPreferredSpan(n);
            }
            return 10.0f;
        }

        public int getResizeWeight(int n) {
            if (this.view != null) {
                return this.view.getResizeWeight(n);
            }
            return 0;
        }

        public int getStartOffset() {
            if (this.view != null) {
                return this.view.getStartOffset();
            }
            return this.getElement().getStartOffset();
        }

        public View getView(int n) {
            return this.view;
        }

        public int getViewCount() {
            return 1;
        }

        public ViewFactory getViewFactory() {
            EditorKit editorKit = BasicTextUI.this.getEditorKit(BasicTextUI.this.editor);
            ViewFactory viewFactory = editorKit.getViewFactory();
            if (viewFactory != null) {
                return viewFactory;
            }
            return BasicTextUI.this;
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.insertUpdate(documentEvent, shape, viewFactory);
            }
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n, shape, bias);
            }
            return null;
        }

        public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n, bias, n2, bias2, shape);
            }
            return null;
        }

        public void paint(Graphics graphics, Shape shape) {
            if (this.view != null) {
                Rectangle rectangle = shape.getBounds();
                this.view.setSize(rectangle.width, rectangle.height);
                this.view.paint(graphics, shape);
            }
        }

        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            BasicTextUI.this.editor.revalidate();
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.removeUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void setParent(View view) {
            throw new Error("Can't set parent on root view");
        }

        public void setSize(float f, float f2) {
            if (this.view != null) {
                this.view.setSize(f, f2);
            }
        }

        void setView(View view) {
            if (this.view != null) {
                this.view.setParent(null);
            }
            this.view = view;
            if (this.view != null) {
                this.view.setParent(this);
            }
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            if (this.view != null) {
                int n = this.view.viewToModel(f, f2, shape, biasArray);
                return n;
            }
            return -1;
        }
    }

    class SafePainter
    implements Runnable {
        Graphics g;

        SafePainter(Graphics graphics) {
            this.g = graphics;
        }

        public void run() {
            BasicTextUI.this.paintSafely(this.g);
        }
    }

    class UpdateHandler
    implements PropertyChangeListener,
    DocumentListener {
        UpdateHandler() {
        }

        public final void changedUpdate(DocumentEvent documentEvent) {
            Rectangle rectangle = BasicTextUI.this.painted ? BasicTextUI.this.getVisibleEditorRect() : null;
            BasicTextUI.this.rootView.changedUpdate(documentEvent, rectangle, BasicTextUI.this.rootView.getViewFactory());
        }

        public final void insertUpdate(DocumentEvent documentEvent) {
            Rectangle rectangle = BasicTextUI.this.painted ? BasicTextUI.this.getVisibleEditorRect() : null;
            BasicTextUI.this.rootView.insertUpdate(documentEvent, rectangle, BasicTextUI.this.rootView.getViewFactory());
        }

        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object instanceof Document || object2 instanceof Document) {
                if (object != null) {
                    ((Document)object).removeDocumentListener(this);
                }
                if (object2 != null) {
                    ((Document)object2).addDocumentListener(this);
                }
                BasicTextUI.this.modelChanged();
            }
            BasicTextUI.this.propertyChange(propertyChangeEvent);
        }

        public final void removeUpdate(DocumentEvent documentEvent) {
            Rectangle rectangle = BasicTextUI.this.painted ? BasicTextUI.this.getVisibleEditorRect() : null;
            BasicTextUI.this.rootView.removeUpdate(documentEvent, rectangle, BasicTextUI.this.rootView.getViewFactory());
        }
    }
}

