/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.util.Enumeration;
import java.util.Stack;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class ElementIterator
implements Cloneable {
    private Element root;
    private Stack elementStack = null;

    public ElementIterator(Document document) {
        this.root = document.getDefaultRootElement();
    }

    public ElementIterator(Element element) {
        this.root = element;
    }

    public synchronized Object clone() {
        try {
            ElementIterator elementIterator = new ElementIterator(this.root);
            elementIterator.elementStack = new Stack();
            int n = 0;
            while (n < this.elementStack.size()) {
                StackItem stackItem = (StackItem)this.elementStack.elementAt(n);
                StackItem stackItem2 = (StackItem)stackItem.clone();
                elementIterator.elementStack.push(stackItem2);
                ++n;
            }
            return elementIterator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Element current() {
        if (this.elementStack == null) {
            return this.first();
        }
        if (!this.elementStack.empty()) {
            StackItem stackItem = (StackItem)this.elementStack.peek();
            Element element = stackItem.getElement();
            int n = stackItem.getIndex();
            if (n == -1) {
                return element;
            }
            return element.getElement(n);
        }
        return null;
    }

    public int depth() {
        return this.elementStack.size();
    }

    private void dumpTree() {
        Element element;
        while ((element = this.next()) != null) {
            System.out.println("elem: " + element.getName());
            AttributeSet attributeSet = element.getAttributes();
            String string = "";
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                Object object = attributeSet.getAttribute(e);
                string = object instanceof AttributeSet ? String.valueOf(string) + e + "=**AttributeSet** " : String.valueOf(string) + e + "=" + object + " ";
            }
            System.out.println("attributes: " + string);
        }
    }

    public Element first() {
        if (this.root == null) {
            return null;
        }
        this.elementStack = new Stack();
        if (this.root.getElementCount() != 0) {
            class Javax_swing_text_ElementIterator$1 {
                /* synthetic */ Javax_swing_text_ElementIterator$1() {
                }
            }
            this.elementStack.push(new StackItem(null, this.root));
        }
        return this.root;
    }

    public Element next() {
        if (this.elementStack == null) {
            return this.first();
        }
        if (this.elementStack.isEmpty()) {
            return null;
        }
        StackItem stackItem = (StackItem)this.elementStack.peek();
        Element element = stackItem.getElement();
        int n = stackItem.getIndex();
        if (n + 1 < element.getElementCount()) {
            Element element2 = element.getElement(n + 1);
            if (element2.isLeaf()) {
                stackItem.incrementIndex();
            } else {
                this.elementStack.push(new StackItem(null, element2));
            }
            return element2;
        }
        this.elementStack.pop();
        if (!this.elementStack.isEmpty()) {
            StackItem stackItem2 = (StackItem)this.elementStack.peek();
            stackItem2.incrementIndex();
            return this.next();
        }
        return null;
    }

    public Element previous() {
        if (this.elementStack == null | this.elementStack.size() == 1) {
            return null;
        }
        StackItem stackItem = (StackItem)this.elementStack.peek();
        Element element = stackItem.getElement();
        int n = stackItem.getIndex();
        if (n > 0) {
            return element.getElement(--n);
        }
        if (n == 0) {
            return element;
        }
        if (n == -1) {
            Object e = this.elementStack.pop();
            stackItem = (StackItem)this.elementStack.peek();
            this.elementStack.push(e);
            element = stackItem.getElement();
            n = stackItem.getIndex();
            return n == -1 ? element : element.getElement(n);
        }
        return null;
    }

    private class StackItem
    implements Cloneable {
        Element item;
        int childIndex;

        private StackItem(Element element) {
            this.item = element;
            this.childIndex = -1;
        }

        /* synthetic */ StackItem(1 var2_2, Element element) {
            this(element);
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        private Element getElement() {
            return this.item;
        }

        private int getIndex() {
            return this.childIndex;
        }

        private void incrementIndex() {
            ++this.childIndex;
        }
    }
}

