/*
 * TestFlowLeft.java
 *
 * Walker M. White
 * October 21, 2001
 */

import javax.swing.*;
import java.awt.*;

/**
 * This class tests out the <code>FlowLayout</code> layout class.
 * In this class, objects flow one after another on a line.  Once
 * a line is filled, the objects move on to the next line.
 * 
 * This example is slightly different from <code>TestFlow</code>.
 * In that example, each line was centered.  This time, each line
 * is anchored to the left.
 */
public class TestFlowLeft extends JFrame {

    /** 
     * Constructor: JFrame with flow (left) layout.
     */
    public TestFlowLeft() {
        // Set the panel to obey the new layout.
        getContentPane().setLayout(new FlowLayout(FlowLayout.LEFT));

        // Add some buttons.
        getContentPane().add(new JButton("One"));
        getContentPane().add(new JButton("Two"));
        getContentPane().add(new JButton("Three"));
        getContentPane().add(new JButton("Four"));
        getContentPane().add(new JButton("Five"));
        getContentPane().add(new JButton("Six"));
        getContentPane().add(new JButton("Seven"));
        getContentPane().add(new JButton("Eight"));
        getContentPane().add(new JButton("Nine"));
        
        // Size the frame and show it.
        setSize(200,400);
        setVisible(true);
    }
 
}
