/*
 * TestBorder.java
 *
 * Walker M. White
 * October 21, 2001
 */
import javax.swing.*;
import java.awt.*;

/**
 * This class tests out the <code>BorderLayout</code> layout class.
 * In this class, objects are arranged in the four primary directions
 * about a central field.  When you add an element, you tell the 
 * container which direction to place it in.
 */
public class TestBorder extends JFrame {
    
    /** 
     * Constructor: JFrame with border layout.
     */
    public TestBorder() {
        // Set the layout of this JFrame
        getContentPane().setLayout(new BorderLayout());
        
        // Add some buttons.
        //add(new JButton("One"),BorderLayout.NORTH);
        getContentPane().add(new JButton("Two"),BorderLayout.SOUTH);
        //add(new JButton("Three"),BorderLayout.EAST);
        getContentPane().add(new JButton("Four"),BorderLayout.WEST);
        getContentPane().add(new JButton("Five"),BorderLayout.CENTER);
        
        // Size the frame and show it.
        setSize(400,400);
        setVisible(true);
    }
    
}