/*
 * SwingFile.java
 *
 * Walker M. White
 * March 27, 2001
 */

import java.io.*;
import java.awt.*;
import javax.swing.*;

/**
 * This class launches a {@link javax.swing.JFileChooser}, allowing
 * the user to chose a file.  It is meant to show off the 
 * "look-and-feel" of the Swing API.  Swing looks more primitive,
 * but that is because it is uniform across all OSs.  Your program
 * will look exactly the same on this computer as it does anywhere
 * else.
 */
public class SwingFile {

    /** 
     * This is a main method; it allows us to type "run SwingFile"
     */
    public static void main(String args[]) {
        
        // Create a file chooser and display it. 
        JFileChooser chooser = new JFileChooser();
        chooser.showOpenDialog(null);
        
        // Get the selected file and display it.    
        File file = chooser.getSelectedFile();
        System.out.println("You chose "+file);
        
        // Any Java GUI application must have this to exit!    
        System.exit(0);
        return;
    }
    
}
