/*
 * PanelGrouping.java
 *
 * Walker M. White
 * October 21, 2001
 */
import javax.swing.*;
import java.awt.*;

/**
 * This class shows how to use panels to group objects together.
 * Each panel can have its very own layout (And should), so that
 * you can organize your components in very complex ways.
 */
public class PanelGrouping extends JFrame {

    /** 
     * Constructor: JFrame with panels grouping subviews
     */
    public PanelGrouping() {
        // Create the frame and put some panels in it.
        JPanel top = new JPanel();
        JPanel bot = new JPanel();
        
        // The top is a FlowLayout
        top.setLayout(new FlowLayout());
        
        // Add some buttons.
        top.add(new JButton("One"));
        top.add(new JButton("Two"));
        
        // Bottom is a GridLayout
        bot.setLayout(new GridLayout(2,2));
        
        // Add buttons to the GridLayout
        bot.add(new JButton("Three"));
        bot.add(new JButton("Four"));
        bot.add(new JButton("Five"));
        
        
        // JFrame is a border layout.
        getContentPane().setLayout(new BorderLayout());
        
        // Add the smaller panels to the bigger one.
        getContentPane().add(top,BorderLayout.NORTH);
        getContentPane().add(bot,BorderLayout.SOUTH);
        
        setSize(200,300);
        setVisible(true);
    }
    
}
