/*
 * MouseDemoView.java
 * Walker M. White
 *
 * October 23, 2001
 */
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;


/**
 * This class implements a simple JFrame, intended to show off mouse commands
 * 
 * @author Walker M. White
 * @version 10/23/2001
 */
public class MouseDemoView extends JFrame {

    private JLabel clickLabel; // Display clicks
    private JLabel localLabel; // Display location
    private JLabel timeLabel;  // Display time stamp
    private JLabel altLabel;   // Display alt modifier
    private JLabel contrLabel; // Display control modifier
    private JLabel shiftLabel; // Display shift modifier
    private JLabel metaLabel;  // Display shift modifier


    /** 
     * Constructor: a new MouseListener
     * Instantiates a view, and then connects this argument as listener
     */ 
    public MouseDemoView() {
        super("Mouse Demonstration");
        
        clickLabel = new JLabel("Number of clicks:");
        localLabel = new JLabel("Current location:");
        timeLabel  = new JLabel("Current timestamp:");
        altLabel   = new JLabel("");
        contrLabel = new JLabel("");
        shiftLabel = new JLabel("");
        metaLabel  = new JLabel("");
        
        Box b = new Box(BoxLayout.Y_AXIS);
        b.add(clickLabel);
        b.add(localLabel);
        b.add(timeLabel);
        b.add(altLabel);
        b.add(contrLabel);
        b.add(shiftLabel);
        b.add(metaLabel);
        
        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(b,BorderLayout.CENTER);
        
        setSize(400,200);
        setVisible(true);
    }
    
    /** Update the mouse display */
    public void updateMouseInfo(MouseEvent e) {
        clickLabel.setText("Number of clicks: "+e.getClickCount());
        localLabel.setText("Current location: "+e.getPoint());
        timeLabel.setText("Current timestamp:"+e.getWhen());
   
        // Modifier keys
        if (e.isAltDown()) {
            altLabel.setText("Alt key is held down");
        } else {
            altLabel.setText("");   
        }
        
        if (e.isControlDown())  {
            contrLabel.setText("Control key is held down");
        } else {
            contrLabel.setText("");   
        }
        
        if (e.isMetaDown()) {
            metaLabel.setText("Meta key is held down");
        } else {
            metaLabel.setText("");   
        }
        
        if (e.isShiftDown()) {
            shiftLabel.setText("Shift key is held down");
        } else {
            shiftLabel.setText("");   
        }
        repaint();
    }
    
}     
  
