/*
 * MouseDemoListener.java
 * Walker M. White
 *
 * October 23, 2001
 */
import javax.swing.*;
import java.awt.event.*;

/**
 * This class implements a MouseListener, to show off how it can be
 * used to track mouse clicks and limited mouse movement.  The 
 * constructor creates an instance of MouseDemoView and adds itself 
 * as a listener to the frame. 
 * 
 * @author Walker M. White
 * @version 10/23/2001
 */
public class MouseDemoListener implements MouseListener {

    private MouseDemoView view; // the JFrame to listen to
    
    /** 
     * Constructor: a new MouseListener
     * Instantiates a view, and then connects this obj as listener
     */ 
    public MouseDemoListener() {
        view = new MouseDemoView();
        view.addMouseListener(this);
    }
    
    
    /**
     * Invoked when the mouse has been clicked on a component.
     * e is a mouse event.
     */
    public void mouseClicked(MouseEvent e) {
        System.out.println("The mouse has been clicked on the frame.");
        view.updateMouseInfo(e);
    }
    
    /**
     * Invoked when the mouse enters a component.
     * e is a mouse event.
     */
    public void mouseEntered(MouseEvent e) {
        System.out.println("The mouse has entered the frame.");
        view.updateMouseInfo(e);
    }
    
    /**
     * Invoked when a mouse has just been released on a component.
     * e is a mouse event.
     */
    public void mouseExited(MouseEvent e) {
        System.out.println("The mouse has exitted the frame.");
        view.updateMouseInfo(e);
    }
    
    /**
     * Invoked when a mouse has been pressed on a component.
     * e is a mouse event.
     */
    public void mousePressed(MouseEvent e) {
        System.out.println("The mouse has been pressed on the frame.");
        view.updateMouseInfo(e);
    }
    
    /**
     * Invoked when a mouse has just been released on a component.
     * e is a mouse event.
     */
    public void mouseReleased(MouseEvent e) {
        System.out.println("The mouse has been released on the frame.");
        view.updateMouseInfo(e);
    }
}
         
  
