/*
 * KeyDemoView.java
 *
 * Walker M. White
 * October 23, 2001
 */
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

/**
 * This is the JFrame for the KeyDemo.  It mainly serves to hold
 * the KeyDemoPanel objects that do all the work.  It is the panels
 * that request focus, not the JFrame.
 * 
 * @author Walker M. White
 * @version 10/23/2001
 */
public class KeyDemoView extends JFrame {
   
    /** 
     * Constructor: JFrame to show off key strokes
     * Given listener for keys, mouse
     */ 
    public KeyDemoView(KeyDemoListener listener) {
        super("Key Demo"); 

        // Create a THREE KeyDemoPanels to put in the window.
        KeyDemoPanel panel1 = new KeyDemoPanel();
        KeyDemoPanel panel2 = new KeyDemoPanel();
        KeyDemoPanel panel3 = new KeyDemoPanel();
        
        // Give them some color so we can identify them
        panel1.setBackground(Color.red);
        panel2.setBackground(Color.blue);
        panel3.setBackground(Color.green);
        

        // Add the listener to each, both mouse and key
        // If I comment out MouseListeners this WILL NOT WORK.  Why?
        panel1.addKeyListener(listener);
        panel1.addMouseListener(listener);
        
        panel2.addKeyListener(listener);
        panel2.addMouseListener(listener);  
        
        panel3.addKeyListener(listener);
        panel3.addMouseListener(listener);  
        
        // Size the window.
        setSize(200,200);
        getContentPane().setLayout(new GridLayout(3,1));
        getContentPane().add(panel1);
        getContentPane().add(panel2);
        getContentPane().add(panel3);
        setVisible(true);
    }
  
}
         
  
