/*
 * KeyDemoPanel.java
 *
 * Walker M. White
 * October 23, 2001
 */
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

/**
 * This is a panel that listens for keystrokes. It has a JLabel
 * in the center to display the last keystroke.
 * 
 * @author Walker M. White
 * @version 10/23/2001
 */
public class KeyDemoPanel extends JPanel {
    
    private JLabel label;  // Label to display keystroke
    
    /** Constructor: JPanel that displays keystrokes */
    public KeyDemoPanel() {
        super();
        label = new JLabel(" ");
        setLayout(new FlowLayout());
        add(label);
        label.setForeground(Color.white);
        label.setFont(new Font("Times New Roman", Font.BOLD, 24));
    }
    
    /** 
     * Sets the label to the given string. Used by the
     * listener to display keystrokes    */
    public void setText(String s) {
        label.setText(s);
        repaint();
    }
}