/*
 * KeyDemoListener.java
 *
 * Walker M. White
 * October 23, 2001
 */
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

/**
 * This class demonstrates how a KeyListener works.  A component can only 
 * receive key events if it has keyboard focus.  Some components automatically 
 * get focus when you use them (ie. TextFields). Others require that you get 
 * focus manually with requestFocus().  A standard way of doing this is to use 
 * a MouseListener  to grant keyboard focus when the mouse enters the component.
 * 
 * @author Walker M. White
 * @version 10/23/2001
 */
public class KeyDemoListener implements KeyListener, MouseListener {
    
    // The primary view
    private KeyDemoView view;
    
// Track the panel with the current focus
    private KeyDemoPanel panel;
    
     
    /** 
     * Invoked when a key has been typed.  This is defined to be a
     * key press immediately followed by a key release.
     * e is a key event.
     */
    public void keyTyped(KeyEvent e) {
        System.out.println("A key was typed.");
        if (panel != null) {
            panel.setText(""+e.getKeyChar());
        }
    }

    /** 
     * Invoked when a key has been pressed.
     * e is a key event.
     */
    public void keyPressed(KeyEvent e) {      
        System.out.println("A key was pressed.");
        if (panel != null) {
            panel.setText(""+e.getKeyChar());
        }   
    }

    /** 
     * Invoked when a key has been released.
     * e is a key event.
     */
    public void keyReleased(KeyEvent e) {
        System.out.println("A key was released.");
        if (panel != null) {
            panel.setText(""+e.getKeyChar());
        }   
    }
    
    /**
     * Invoked when the mouse has been clicked on a component.
     * e is a mouse event.
     */
    public void mouseClicked(MouseEvent e) { }
    
    /**
     * Invoked when the mouse enters a component.
     * e is a mouse event.
     */
    public void mouseEntered(MouseEvent e) {
        // Request input focus from the parent.
        System.out.println("The focus has changed.");
        if (panel != null) {
            panel.setText("");
        }
        panel = (KeyDemoPanel)e.getSource();
        panel.requestFocus();
    }
    
    /**
     * Invoked when a mouse has just been released on a component.
     * e is a mouse event.
     */
    public void mouseExited(MouseEvent e) {}
    
    /**
     * Invoked when a mouse has been pressed on a component.
     * e is a mouse event.
     */
    public void mousePressed(MouseEvent e) {}

    /**
     * Invoked when a mouse has just been released on a component.
     * e is a mouse event.
     */
    public void mouseReleased(MouseEvent e) {}

    /** 
     * Constructor: a new KeyListener, MouseListener
     * Instantiates a view, connecting this obj as listener
     */ 
    public KeyDemoListener() {
        view = new KeyDemoView(this);
    }
  
}
         
  
