/*
 * ButtonDemoView.java
 *
 * Walker M. White
 *
 * October 23, 2001
 */
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

/**
 * This class is the view for an ActionListener.  It has buttons
 * that can change the color of the background.
 * 
 * @author Walker M. White
 * @version 10/23/2001
 */
public class ButtonDemoView extends JFrame {
 
    private JPanel panel;      // The panel to color
    private JButton[] buttons; // The buttons to press
    
    /** 
     * Constructor: JFrame to show of buttons
     * Given names for buttons, and their listener
     */ 
    public ButtonDemoView(String[] names, ActionListener listener) {
        super("Button Demo");
        
        panel = new JPanel();
        panel.setLayout(new FlowLayout());
 
        buttons = new JButton[names.length];
        for (int ii=0; ii < names.length; ii = ii + 1) {
            buttons[ii] = new JButton(names[ii]);
            buttons[ii].addActionListener(listener);
            panel.add(buttons[ii]);
        }

        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(panel,BorderLayout.CENTER);
        
        setSize(300,300);
        setVisible(true);
    }
    
    /**
     * Sets the color of the background.  Used by the
     * listener for visual effect.    */
    public void setColor(Color c) {
        panel.setBackground(c);
        panel.repaint();
    }
}
         
  
