/*
 * ButtonDemoListener.java
 *
 * Walker M. White
 * October 23, 2001
 */
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

/**
 * This class demonstrates how to use an ActionListener, which
 * listens to buttons.
 * 
 * @author Walker M. White
 * @version 10/23/2001
 */
public class ButtonDemoListener implements ActionListener {
 
    // Constants to define the user interface
    private static final String[] names = {"red","blue","green","magenta","cyan","yellow"};
    private static final Color[] colors = {Color.red,Color.blue,Color.green,Color.magenta,
        Color.cyan,Color.yellow};

    private ButtonDemoView view; // The view to store the buttons.
    
    /** 
     * Constructor: a new button listener
     * Instantiates a view, connecting this obj as listener
     */ 
    public ButtonDemoListener() {
        view = new ButtonDemoView(names,this);
    }

    /** 
     * Invoked when the button has been pressed.
     * e is an action event.
     */
    public void actionPerformed(ActionEvent e) {
        // The source is a button.
        JButton button = (JButton)e.getSource();
        
        // Find the button with the right name
        for(int ii = 0; ii < names.length; ii = ii + 1) {
            if (names[ii].equals(button.getText())) {
                view.setColor(colors[ii]);
            }
        }
    }
}
         
  
