/*
 * BoxGrouping.java
 *
 * Walker M. White
 * October 21, 2001
 */

import javax.swing.*;
import java.awt.*;

/**
 * This class shows how to use boxes to group objects together.
 * Boxes are like JPanels, except that it only supports the
 * BoxLayout format.
 */
public class BoxGrouping extends JFrame {

    /** 
     * Constructor: JFrame with boxes grouping subviews
     */
    public BoxGrouping() {
        // Box with three buttons
        Box b1 = new Box(BoxLayout.Y_AXIS);
        b1.add(new JButton("One"));
        b1.add(new JButton("Two"));
        b1.add(new JButton("Three"));
        
        // Box with two buttons
        Box b2 = new Box(BoxLayout.Y_AXIS);
        b2.add(new JButton("Four"));
        b2.add(new JButton("Five"));
        
        // Box with one button
        Box b3 = new Box(BoxLayout.Y_AXIS);
        b3.add(new JButton("Six"));
        
        // Align these three boxes in a vertical layout      
        Box b = new Box(BoxLayout.X_AXIS);
        b.add(b1);
        b.add(b2);
        b.add(b3); 
        
        // Use a border layout in the JFrame
        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(b,BorderLayout.CENTER);
        
        // Size the frame and show it.
        setSize(300,200);
        setVisible(true);
    }
    
}