/*
 * AWTFile.java
 *
 * Walker M. White
 * March 27, 2001
 */
import java.awt.*;

/** 
 * This class launches a {@link java.awt.FileDialog}, allowing
 * the user to chose a file.  It is meant to show off the
 * "look-and-feel" of the Abstract Windowing Kit.  In particular,
 * components in AWT look exactly like they do in normal programs
 * for this OS.
 */
public class AWTFile {

    /** 
     * This is a main method; it allows us to type "run AWTFile"
     */
    public static void main(String args[]) {
        
        // Create a file chooser and display it. 
        FileDialog chooser = new FileDialog(new Frame("Choose a File"));
        chooser.setVisible(true);
        
        // Get the selected file and display it.   
        String filename = chooser.getFile();
        System.out.println("You chose "+filename);   
        
        // AWT objects must be disposed before exitting.
        chooser.dispose();
        
        // Any Java GUI application must have this to exit!    
        System.exit(0);
        return;
    }
    
}
