import java.awt.*;

/** An instance is a piece that is on the board of the J*Man game.*/
public abstract class Piece {
    
    /** Constant used to identify a Block. */
    public static final int BLOCK= 0;  // piece is a block
    /** Constant used to identify J*man. */
    public static final int JMAN= 1;   // piece is the J*man
    /** Constant used to identify a Walker. */
    public static final int WALKER= 2; // piece is a walker
    /** Constant used to identify a Pillar. */
    public static final int PILLAR= 3; // piece is a pillar
    
    private Color color;   // This piece's color.
    private int x, y;      // The (x, y) coordinates of this piece in the game board.
    private int type;      // The type of piece: one of the four constants
                           // of this class.
    private boolean acted; // = "this piece has already acted in this round".
    private JManGUI m;     // The GUI on which this piece is placed.
   
    
    /** Constructor: a Piece on JManGUI m with type t and color c, to be
        placed on board at position (x, y)
        Precondition: t is one of the four constants of this class:
                      BLOCK, JMAN, WALKER, or PILLAR.
                      (x, y) is a position on the board, and c is one of
                      Color.red, Color.green, Color.yellow, and Color.white
        */
    public Piece(int t, JManGUI m, int x, int y, Color c) {
        
        
    }
    
    /** = this piece's type --either BLOCK, JMAN, WALKER, or PILLAR. */
    public int getType() {
        return 0;
    }
    
    /** = this piece's x location on the board. */
    public int getX() {
        return 0;
    }
    
    /** = this piece's y location on the board. */
    public int getY() {
        return 0;
    }
    
    /** = this piece's color. */
    public Color getColor() {
        return null;
    }
    
    /** = the color of this piece, as a capitalized word (e.g. "Red").
        = the empty string if it is not one of objects Color.red,
          Color.green, Color.yellow, and Color.white */
    public String getColorWord() {
        return "";
    }
    
    /** = "This piece has already acted this round". */
    public boolean hasActed() {
        return false;
    }
    
    /** = the JManGUI that contains the board that this piece is on. */
    public JManGUI getGUI() {
        return null;
    }
    
    /** Set this piece's x location on the board to x. */
    public void setX(int x) {
        
    }
    
    /** Set this piece's y location on the board to y. */
    public void setY(int y) {
        
    }
    
    /** Set this piece's color to c.
        Precondition: c is Color.white and this is a block, OR
        c is Color.red, Color.green, or Color.yellow. */
    public void setColor(Color c) {
        color= c;
    }
    
    /** Set the state of this piece to the value of acted.*/
    public void setActed(boolean acted) {
        
    }
    
    /** Make this piece take one action. What a piece does on
        its action is defined in the assignment. */
    public abstract void act();
    
    /** = a random integer in the range lo..hi, with all integers in
          the range being equally likely. 
          Precondition lo < hi. */
    public static int rand(int lo, int hi) {
        return (int)(Math.random()*(hi-lo+1))+lo;
    }
    
}