/**Demo CS1110, 22 Sep 2011 */
public class D {
    
    /* General idea:
     * 1. Pick out the pieces in the input
     * 2. Construct the output
     * 
     *    s.indexOf(s1) = index of the start of s1 in s
     *                     (-1 if s1 is not in s)
     */
    
    /** = s but prepended with 0's, if necessary,
      so it is at least 2 char long. */
    public static String prepend0(String s) {
        if (s.length() >= 2) {
         return s;   
        }
        
        if (s.length() == 1) {
         return "0" + s;   
        }
        return "00";
    }
    
    /* F1: yyyy.mm.dd
       F2: month/day/yyyy
       where month and day are 1 or 2 digits */
    
    /** = the date in String s, but changed, if necessary to form F1.
      * Precondition. s is a date in either form F1 or form F2 */
    public static String reformat(String s) {
        int h= s.indexOf("/"); //index of first / (-1 if none)
        if (h < 0) {
            return s;
        }
        // { s is in format F2 }
        int k= s.lastIndexOf("/");   //index of second /
        
        return s.substring(k+1) + "." +
             prepend0(s.substring(0, h)) + "." +
             prepend0(s.substring(h+1, k));
    }
    
    
    
    
    /** = "Date s1 occurs before date s2".
      * Precondition: s1 and s2 are date in form F1 or F2 */
    public static boolean comesBefore(String s1, String s2) {
        return false;
    }
    
    /** = s in the form <last name>, <first name>.
      Precondition: s has the form <first name>  <last name>
      with 1 blank between the two names.
      E.g. :From "David Gries" produce "David Gries"*/
    public static String revNames(String s) {
        int k= s.indexOf(" ");
        String first= s.substring(0,k);
        String last= s.substring(k+1);
        return last + ", " + first;
    }
    
    /** = s in the form <first name> <last Name>
      * Precondition: s is in the form
      *           <last name>,   <first name>
      * where 0 or more blanks can appear after the comma*/
    public static String rev1(String s) {
        int comma= s.indexOf(",");
        int beforeFirst;
        // Put in beforeFirst the index of the char
        // before the first name.
        beforeFirst= s.lastIndexOf(" ");
        if (beforeFirst == -1) {
            beforeFirst= comma;
        }
        String lastName= s.substring(0, comma);
        
        return s.substring(beforeFirst+1) + " " +
            lastName;
    }
    
    /** = English equivalent of n.
      Precondition: 0 < n < 1,000,000.
      Examples:
      3:      "three"
      45:     "forty five"
      100:    "one hundred"
      127:    "one hunded twenty seven"
      1001:   "one thousand one"
      999099: "nine hundred ninety thousand ninety nine*/
    public static String anglicize(int n) {
        return "" + n;
    }
    
    
}