/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import edu.rice.cs.plt.object.ObjectUtil;
import edu.rice.cs.plt.tuple.Option;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceInfo
implements Comparable<SourceInfo> {
    public static final SourceInfo NONE = new SourceInfo(Option.<File>none(), 0, 0, 0, 0);
    private final Option<File> _file;
    private final int _startLine;
    private final int _startColumn;
    private final int _endLine;
    private final int _endColumn;

    public static SourceInfo point(File f, int line, int column) {
        return new SourceInfo(Option.wrap(f), line, column, line, column);
    }

    public static SourceInfo range(File f, int startLine, int startColumn, int endLine, int endColumn) {
        return new SourceInfo(Option.wrap(f), startLine, startColumn, endLine, endColumn);
    }

    public static SourceInfo extend(SourceInfo si, int endLine, int endColumn) {
        return new SourceInfo(si._file, si._startLine, si._startColumn, endLine, endColumn);
    }

    public static SourceInfo extend(Wrapper wrapper, int endLine, int endColumn) {
        return SourceInfo.extend(wrapper.getSourceInfo(), endLine, endColumn);
    }

    public static SourceInfo prepend(int startLine, int startColumn, SourceInfo si) {
        return new SourceInfo(si._file, startLine, startColumn, si._endLine, si._endColumn);
    }

    public static SourceInfo prepend(int startLine, int startColumn, Wrapper wrapper) {
        return SourceInfo.prepend(startLine, startColumn, wrapper.getSourceInfo());
    }

    public static SourceInfo span(SourceInfo first, SourceInfo second) {
        assert (ObjectUtil.equal(first._file, second._file));
        return new SourceInfo(first._file, first._startLine, first._startColumn, second._endLine, second._endColumn);
    }

    public static SourceInfo span(SourceInfo first, Wrapper second) {
        return SourceInfo.span(first, second.getSourceInfo());
    }

    public static SourceInfo span(Wrapper first, SourceInfo second) {
        return SourceInfo.span(first.getSourceInfo(), second);
    }

    public static SourceInfo span(Wrapper first, Wrapper second) {
        return SourceInfo.span(first.getSourceInfo(), second.getSourceInfo());
    }

    private SourceInfo(Option<File> file, int startLine, int startColumn, int endLine, int endColumn) {
        this._file = file;
        this._startLine = startLine;
        this._startColumn = startColumn;
        this._endLine = endLine;
        this._endColumn = endColumn;
    }

    public File getFile() {
        return this._file.unwrap(null);
    }

    public String getFilename() {
        return this._file.isNone() ? "(no file)" : this._file.unwrap().getPath();
    }

    public int getStartLine() {
        return this._startLine;
    }

    public int getStartColumn() {
        return this._startColumn;
    }

    public int getEndLine() {
        return this._endLine;
    }

    public int getEndColumn() {
        return this._endColumn;
    }

    public String toString() {
        return "[" + this.getFilename() + ": " + "(" + this._startLine + "," + this._startColumn + ")-" + "(" + this._endLine + "," + this._endColumn + ")]";
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SourceInfo casted = (SourceInfo)obj;
        return this._file.equals(casted._file) && this._startLine == casted._startLine && this._startColumn == casted._startColumn && this._endLine == casted._endLine && this._endColumn == casted._endColumn;
    }

    public int hashCode() {
        return ObjectUtil.hash(this.getClass(), this._file, this._startLine, this._startColumn, this._endLine, this._endColumn);
    }

    @Override
    public int compareTo(SourceInfo that) {
        int result = Option.comparator().compare(this._file, that._file);
        if (result == 0) {
            result = ObjectUtil.compare(this._startLine, that._startLine, this._startColumn, that._startColumn, this._endLine, that._endLine, this._endColumn, that._endColumn);
        }
        return result;
    }

    public static interface Wrapper {
        public SourceInfo getSourceInfo();
    }
}

