/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public abstract class InputStreamRedirector
extends InputStream {
    protected ArrayList<Character> _buffer = new ArrayList(60);

    protected abstract String _getInput() throws IOException;

    private void _readInputIntoBuffer() throws IOException {
        String input = this._getInput();
        for (int i = 0; i < input.length(); ++i) {
            this._buffer.add(new Character(input.charAt(i)));
        }
    }

    public synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int numRead = 0;
        if (this.available() == 0) {
            this._readInputIntoBuffer();
            if (this.available() == 0) {
                return -1;
            }
        }
        for (int i = off; i < off + len && this.available() != 0; ++i) {
            b[i] = (byte)this._buffer.remove(0).charValue();
            ++numRead;
        }
        return numRead;
    }

    public synchronized int read() throws IOException {
        if (this.available() == 0) {
            this._readInputIntoBuffer();
            if (this.available() == 0) {
                return -1;
            }
        }
        return this._buffer.remove(0).charValue();
    }

    public int available() {
        return this._buffer.size();
    }
}

