/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

import edu.rice.cs.plt.concurrent.CompletionMonitor;
import edu.rice.cs.plt.concurrent.IncrementalTask;
import edu.rice.cs.plt.concurrent.IncrementalTaskController;
import edu.rice.cs.plt.lambda.WrappedException;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorIncrementalTaskController<I, R>
extends IncrementalTaskController<I, R> {
    private Executor _executor;
    private IncrementalTask<? extends I, ? extends R> _task;
    private CompletionMonitor _continueMonitor;
    private volatile Thread _t;

    public ExecutorIncrementalTaskController(Executor executor, IncrementalTask<? extends I, ? extends R> task, boolean ignoreIntermediate) {
        super(ignoreIntermediate);
        this._executor = executor;
        this._task = task;
        this._continueMonitor = new CompletionMonitor(false);
        this._t = null;
    }

    @Override
    protected void doStart() {
        this._continueMonitor.signal();
        this._executor.execute(new Runnable(){

            public void run() {
                ExecutorIncrementalTaskController.this._t = Thread.currentThread();
                ExecutorIncrementalTaskController.this.started();
                try {
                    while (!ExecutorIncrementalTaskController.this._task.isResolved()) {
                        this.authorizeContinue();
                        ExecutorIncrementalTaskController.this.stepped(ExecutorIncrementalTaskController.this._task.step());
                    }
                    this.authorizeContinue();
                    ExecutorIncrementalTaskController.this.finishedCleanly(ExecutorIncrementalTaskController.this._task.value());
                }
                catch (WrappedException e) {
                    if (e.getCause() instanceof InterruptedException) {
                        ExecutorIncrementalTaskController.this.stopped();
                    } else {
                        ExecutorIncrementalTaskController.this.finishedWithTaskException(e);
                    }
                }
                catch (RuntimeException e) {
                    ExecutorIncrementalTaskController.this.finishedWithTaskException(e);
                }
                catch (InterruptedException e) {
                    ExecutorIncrementalTaskController.this.stopped();
                }
                catch (Throwable t) {
                    ExecutorIncrementalTaskController.this.finishedWithImplementationException(new WrappedException(t));
                }
            }

            private void authorizeContinue() throws InterruptedException {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (!ExecutorIncrementalTaskController.this._continueMonitor.isSignaled()) {
                    ExecutorIncrementalTaskController.this.paused();
                    ExecutorIncrementalTaskController.this._continueMonitor.ensureSignaled();
                    ExecutorIncrementalTaskController.this.started();
                }
            }
        });
    }

    @Override
    protected void doPause() {
        this._continueMonitor.reset();
    }

    @Override
    protected void doResume() {
        this._continueMonitor.signal();
    }

    @Override
    protected void doStop() {
        this._t.interrupt();
    }

    @Override
    protected void discard() {
        this._executor = null;
        this._task = null;
        this._continueMonitor = null;
        this._t = null;
    }
}

