/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.AbstractOneToOneRelation;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.collect.ImmutableMap;
import edu.rice.cs.plt.collect.LambdaMap;
import edu.rice.cs.plt.lambda.Thunk;
import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedOneToOneRelation<T1, T2>
extends AbstractOneToOneRelation<T1, T2>
implements Serializable {
    private Map<T1, T2> _firstMap;
    private LambdaMap<T1, T2> _functionMap;
    private Map<T2, T1> _secondMap;
    private LambdaMap<T2, T1> _injectionMap;

    public IndexedOneToOneRelation() {
        this(CollectUtil.hashMapFactory(), CollectUtil.hashMapFactory());
    }

    public IndexedOneToOneRelation(Thunk<Map<T1, T2>> firstIndexFactory, Thunk<Map<T2, T1>> secondIndexFactory) {
        this._firstMap = firstIndexFactory.value();
        this._functionMap = new ImmutableMap<T1, T2>(this._firstMap);
        this._secondMap = secondIndexFactory.value();
        this._injectionMap = new ImmutableMap<T2, T1>(this._secondMap);
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public LambdaMap<T1, T2> functionMap() {
        return this._functionMap;
    }

    @Override
    public LambdaMap<T2, T1> injectionMap() {
        return this._injectionMap;
    }

    @Override
    public boolean add(T1 first, T2 second) {
        boolean result = this.validateAdd(first, second);
        if (result) {
            this._firstMap.put(first, second);
            this._secondMap.put(second, first);
        }
        return result;
    }

    private boolean validateAdd(T1 first, T2 second) {
        if (this._firstMap.containsKey(first)) {
            T2 current = this._firstMap.get(first);
            if (current == null ? second == null : current.equals(second)) {
                return false;
            }
            throw new IllegalArgumentException("Relation already contains an entry for " + first);
        }
        if (this._secondMap.containsKey(second)) {
            throw new IllegalArgumentException("Relation already contains an entry for " + second);
        }
        return true;
    }

    @Override
    public boolean remove(T1 first, T2 second) {
        boolean result = this.contains(first, second);
        if (result) {
            this._firstMap.remove(first);
            this._secondMap.remove(second);
        }
        return result;
    }

    @Override
    public void clear() {
        this._firstMap.clear();
        this._secondMap.clear();
    }

    public static <T1, T2> IndexedOneToOneRelation<T1, T2> makeHashBased() {
        return new IndexedOneToOneRelation<T1, T2>(CollectUtil.<T1, T2>hashMapFactory(), CollectUtil.<T2, T1>hashMapFactory());
    }

    public static <T1, T2> IndexedOneToOneRelation<T1, T2> makeLinkedHashBased() {
        return new IndexedOneToOneRelation<T1, T2>(CollectUtil.<T1, T2>linkedHashMapFactory(), CollectUtil.<T2, T1>linkedHashMapFactory());
    }

    public static <T1 extends Comparable<? super T1>, T2 extends Comparable<? super T2>> IndexedOneToOneRelation<T1, T2> makeTreeBased() {
        return new IndexedOneToOneRelation<T1, T2>(CollectUtil.<T1, T2>treeMapFactory(), CollectUtil.<T2, T1>treeMapFactory());
    }
}

