/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.AbstractPredicateSet;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.collect.Relation;
import edu.rice.cs.plt.iter.MappedIterator;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRelation<T1, T2>
extends AbstractPredicateSet<Pair<T1, T2>>
implements Relation<T1, T2> {
    @Override
    public abstract boolean isInfinite();

    @Override
    public abstract boolean hasFixedSize();

    @Override
    public abstract boolean isStatic();

    @Override
    public abstract boolean contains(T1 var1, T2 var2);

    @Override
    public abstract boolean contains(Object var1);

    @Override
    public abstract Iterator<Pair<T1, T2>> iterator();

    @Override
    public abstract PredicateSet<T1> firstSet();

    @Override
    public abstract PredicateSet<T2> matchFirst(T1 var1);

    @Override
    public abstract PredicateSet<T2> secondSet();

    @Override
    public abstract PredicateSet<T1> matchSecond(T2 var1);

    @Override
    public boolean add(T1 first, T2 second) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(T1 first, T2 second) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Pair<T1, T2> p) {
        return this.add(p.first(), p.second());
    }

    @Override
    public boolean remove(Object o) {
        Option cast = CollectUtil.castIfContains(this, o);
        if (cast.isSome()) {
            return this.remove(((Pair)cast.unwrap()).first(), ((Pair)cast.unwrap()).second());
        }
        return false;
    }

    @Override
    public Relation<T2, T1> inverse() {
        return new InverseRelation();
    }

    @Override
    public boolean containsFirst(T1 first) {
        return this.firstSet().contains((Object)first);
    }

    @Override
    public PredicateSet<T2> excludeFirsts() {
        return this.secondSet();
    }

    @Override
    public boolean containsSecond(T2 second) {
        return this.secondSet().contains((Object)second);
    }

    @Override
    public PredicateSet<T1> excludeSeconds() {
        return this.firstSet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InverseRelation
    extends AbstractPredicateSet<Pair<T2, T1>>
    implements Relation<T2, T1>,
    Serializable {
        protected InverseRelation() {
        }

        @Override
        public int size() {
            return AbstractRelation.this.size();
        }

        @Override
        public int size(int bound) {
            return AbstractRelation.this.size(bound);
        }

        @Override
        public boolean isEmpty() {
            return AbstractRelation.this.isEmpty();
        }

        @Override
        public boolean isInfinite() {
            return AbstractRelation.this.isInfinite();
        }

        @Override
        public boolean hasFixedSize() {
            return AbstractRelation.this.hasFixedSize();
        }

        @Override
        public boolean isStatic() {
            return AbstractRelation.this.isStatic();
        }

        @Override
        public boolean contains(Object o) {
            return o instanceof Pair && AbstractRelation.this.contains(((Pair)o).inverse());
        }

        @Override
        public Iterator<Pair<T2, T1>> iterator() {
            return new MappedIterator(AbstractRelation.this.iterator(), Pair.inverter());
        }

        @Override
        public boolean add(Pair<T2, T1> pair) {
            return AbstractRelation.this.add(pair.inverse());
        }

        @Override
        public boolean remove(Object o) {
            return o instanceof Pair && AbstractRelation.this.remove(((Pair)o).inverse());
        }

        @Override
        public void clear() {
            AbstractRelation.this.clear();
        }

        @Override
        public boolean contains(T2 f, T1 s) {
            return AbstractRelation.this.contains(s, f);
        }

        @Override
        public boolean add(T2 f, T1 s) {
            return AbstractRelation.this.add(s, f);
        }

        @Override
        public boolean remove(T2 f, T1 s) {
            return AbstractRelation.this.remove(s, f);
        }

        @Override
        public Relation<T1, T2> inverse() {
            return AbstractRelation.this;
        }

        @Override
        public PredicateSet<T2> firstSet() {
            return AbstractRelation.this.secondSet();
        }

        @Override
        public boolean containsFirst(T2 f) {
            return AbstractRelation.this.containsSecond(f);
        }

        @Override
        public PredicateSet<T1> matchFirst(T2 f) {
            return AbstractRelation.this.matchSecond(f);
        }

        @Override
        public PredicateSet<T1> excludeFirsts() {
            return AbstractRelation.this.excludeSeconds();
        }

        @Override
        public PredicateSet<T1> secondSet() {
            return AbstractRelation.this.firstSet();
        }

        @Override
        public boolean containsSecond(T1 s) {
            return AbstractRelation.this.containsFirst(s);
        }

        @Override
        public PredicateSet<T2> matchSecond(T1 s) {
            return AbstractRelation.this.matchFirst(s);
        }

        @Override
        public PredicateSet<T2> excludeSeconds() {
            return AbstractRelation.this.excludeFirsts();
        }
    }
}

