/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels.tree;

import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.tree.JExpression;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor_void;
import edu.rice.cs.javalanglevels.tree.TabPrintWriter;
import edu.rice.cs.javalanglevels.tree.VariableInitializerI;
import java.io.StringWriter;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayInitializer
extends JExpression
implements VariableInitializerI {
    private final VariableInitializerI[] _items;

    public ArrayInitializer(SourceInfo in_sourceInfo, VariableInitializerI[] in_items) {
        super(in_sourceInfo);
        if (in_items == null) {
            throw new IllegalArgumentException("Parameter 'items' to the ArrayInitializer constructor was null. This class may not have null field values.");
        }
        this._items = in_items;
    }

    public final VariableInitializerI[] getItems() {
        return this._items;
    }

    @Override
    public <RetType> RetType visit(JExpressionIFVisitor<RetType> visitor) {
        return visitor.forArrayInitializer(this);
    }

    @Override
    public void visit(JExpressionIFVisitor_void visitor) {
        visitor.forArrayInitializer(this);
    }

    public String toString() {
        StringWriter w = new StringWriter();
        this.output(w);
        return w.toString();
    }

    public void output(Writer writer) {
        this.outputHelp(new TabPrintWriter(writer, 2));
    }

    @Override
    public void outputHelp(TabPrintWriter writer) {
        writer.print("ArrayInitializer:");
        writer.indent();
        writer.startLine("");
        writer.print("sourceInfo = ");
        SourceInfo temp_sourceInfo = this.getSourceInfo();
        if (temp_sourceInfo == null) {
            writer.print("null");
        } else {
            writer.print(temp_sourceInfo);
        }
        writer.startLine("");
        writer.print("items = ");
        writer.print("{");
        writer.indent();
        for (int i = 0; i < this.getItems().length; ++i) {
            VariableInitializerI temp_items = this.getItems()[i];
            writer.startLine("#" + i + ": ");
            if (temp_items == null) {
                writer.print("null");
                continue;
            }
            temp_items.outputHelp(writer);
        }
        writer.unindent();
        if (this.getItems().length > 0) {
            writer.startLine("");
        }
        writer.print("}");
        writer.unindent();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        ArrayInitializer casted = (ArrayInitializer)obj;
        if (this.getItems().length != casted.getItems().length) {
            return false;
        }
        for (int i = 0; i < this.getItems().length; ++i) {
            if (this.getItems()[i].equals(casted.getItems()[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int generateHashCode() {
        int code = this.getClass().hashCode();
        code ^= 0;
        for (int i = 0; i < this.getItems().length; ++i) {
            code ^= this.getItems()[i].hashCode();
        }
        return code;
    }
}

