/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.BlockData;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.TypeChecker;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.NullLiteral;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Data {
    protected String _name = "";
    protected LinkedList<VariableData> _vars = new LinkedList();
    protected LinkedList<Data> _enclosingData = new LinkedList();
    protected ModifiersAndVisibility _modifiersAndVisibility = null;
    protected Data _outerData;
    protected LinkedList<SymbolData> _innerClasses;
    protected LinkedList<BlockData> _blocks;
    protected Iterator<BlockData> _blockIterator;

    public Data(Data outerData) {
        this._outerData = outerData;
        if (outerData != null) {
            this._enclosingData.addLast(this._outerData);
        }
        this._innerClasses = new LinkedList();
        this._blocks = new LinkedList();
        this._blockIterator = null;
    }

    public String getName() {
        return this._name;
    }

    void setName(String name) {
        this._name = name;
    }

    public Boolean isAnonymousClass() {
        int lastIndex = this._name.lastIndexOf("$");
        try {
            return lastIndex < 0 && Integer.parseInt(this._name.substring(lastIndex + 1)) >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public Boolean isDoublyAnonymous() {
        if (!this.isAnonymousClass().booleanValue()) {
            return false;
        }
        for (Data d : this.getEnclosingData()) {
            if (!d.isAnonymousClass().booleanValue()) continue;
            return true;
        }
        return false;
    }

    void setVars(LinkedList<VariableData> vars) {
        this._vars = vars;
    }

    public VariableData getVar(String name) {
        for (VariableData vd : this._vars) {
            if (!vd.getName().equals(name)) continue;
            return vd;
        }
        return null;
    }

    public LinkedList<VariableData> getVars() {
        return this._vars;
    }

    public LinkedList<Data> getEnclosingData() {
        return this._enclosingData;
    }

    public void addEnclosingData(Data enclosingData) {
        if (!this._enclosingData.contains(enclosingData)) {
            this._enclosingData.addFirst(enclosingData);
        }
    }

    public void setEnclosingData(LinkedList<Data> d) {
        this._enclosingData = d;
    }

    private boolean _repeatedName(VariableData vr) {
        for (VariableData next : this._vars) {
            if (!vr.getName().equals(next.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean addVar(VariableData var) {
        if (!this._repeatedName(var)) {
            this._vars.addLast(var);
            return true;
        }
        return false;
    }

    public boolean addVars(VariableData[] vars) {
        boolean success = true;
        for (int i = 0; i < vars.length; ++i) {
            if (!this._repeatedName(vars[i])) {
                this._vars.addLast(vars[i]);
                continue;
            }
            success = false;
        }
        return success;
    }

    public boolean addFinalVars(VariableData[] vars) {
        boolean success = true;
        for (int i = 0; i < vars.length; ++i) {
            if (!this._repeatedName(vars[i])) {
                vars[i].setFinal();
                this._vars.addLast(vars[i]);
                continue;
            }
            success = false;
        }
        return success;
    }

    public ModifiersAndVisibility getMav() {
        return this._modifiersAndVisibility;
    }

    public void setMav(ModifiersAndVisibility modifiersAndVisibility) {
        this._modifiersAndVisibility = modifiersAndVisibility;
    }

    public abstract SymbolData getSymbolData();

    public Data getOuterData() {
        return this._outerData;
    }

    public void setOuterData(Data outerData) {
        if (outerData == null) {
            assert (this._outerData == null);
            return;
        }
        if (this._outerData != null) {
            throw new RuntimeException("Internal Program Error: Trying to reset an outer data to " + outerData.getName() + " for " + this.getName() + " that has already been set.  Please report this bug.");
        }
        this._outerData = outerData;
        this._enclosingData.addLast(this._outerData);
    }

    public boolean isOuterData(Data d) {
        for (Data outerData = this._outerData; outerData != null && !LanguageLevelVisitor.isJavaLibraryClass(outerData.getName()); outerData = outerData.getOuterData()) {
            if (outerData != d) continue;
            return true;
        }
        return false;
    }

    public static String dollarSignsToDots(String s) {
        return s.replace('$', '.');
    }

    public SymbolData getNextAnonymousInnerClass() {
        String name = this.getSymbolData().getName() + "$" + this.getSymbolData().preincrementAnonymousInnerClassNum();
        LinkedList<SymbolData> myDatas = this.getInnerClasses();
        SymbolData myData = null;
        for (int i = 0; i < myDatas.size(); ++i) {
            if (!myDatas.get(i).getName().equals(name)) continue;
            myData = myDatas.get(i);
            break;
        }
        return myData;
    }

    public void resetBlockIterator() {
        this._blockIterator = null;
    }

    public BlockData getNextBlock() {
        if (this._blockIterator == null) {
            this._blockIterator = this._blocks.iterator();
        }
        if (this._blockIterator.hasNext()) {
            return this._blockIterator.next();
        }
        return null;
    }

    public void addBlock(BlockData b) {
        this._blocks.add(b);
    }

    public void removeAllBlocks() {
        this._blocks.clear();
    }

    public SymbolData getInnerClassOrInterface(String name) {
        int firstIndexOfDot = name.indexOf(".");
        int firstIndexOfDollar = name.indexOf("$");
        if (firstIndexOfDot == -1) {
            firstIndexOfDot = firstIndexOfDollar;
        } else if (firstIndexOfDollar >= 0 && firstIndexOfDollar < firstIndexOfDot) {
            firstIndexOfDot = firstIndexOfDollar;
        }
        SymbolData privateResult = null;
        SymbolData result = this.getInnerClassOrInterfaceHelper(name, firstIndexOfDot);
        if (result != null) {
            SymbolData outerPiece = firstIndexOfDot > 0 ? this.getInnerClassOrInterfaceHelper(name.substring(0, firstIndexOfDot), -1) : result;
            if (TypeChecker.checkAccessibility(outerPiece.getMav(), outerPiece, this.getSymbolData())) {
                return result;
            }
            privateResult = result;
            result = null;
        }
        if (this._outerData != null && (result = this._outerData.getInnerClassOrInterface(name)) != null) {
            return result;
        }
        return privateResult;
    }

    protected SymbolData getInnerClassOrInterfaceHelper(String nameToMatch, int firstIndexOfDot) {
        Iterator<SymbolData> iter2 = this.innerClassesAndInterfacesIterator();
        while (iter2.hasNext()) {
            SymbolData sd = iter2.next();
            String sdName = sd.getName();
            sdName = LanguageLevelVisitor.getUnqualifiedClassName(sdName);
            if (firstIndexOfDot == -1) {
                if (!sdName.equals(nameToMatch)) continue;
                return sd;
            }
            if (!sdName.equals(nameToMatch.substring(0, firstIndexOfDot))) continue;
            return sd.getInnerClassOrInterface(nameToMatch.substring(firstIndexOfDot + 1));
        }
        return null;
    }

    public Iterator<SymbolData> innerClassesAndInterfacesIterator() {
        return this._innerClasses.iterator();
    }

    public LinkedList<SymbolData> getInnerClasses() {
        return this._innerClasses;
    }

    public void setInnerClasses(LinkedList<SymbolData> innerClasses) {
        this._innerClasses = innerClasses;
    }

    public void addInnerClass(SymbolData innerClass) {
        this._innerClasses.addLast(innerClass);
    }

    public boolean hasModifier(String modifier) {
        if (this.getMav() == null) {
            return false;
        }
        String[] mavStrings = this._modifiersAndVisibility.getModifiers();
        for (int i = 0; i < mavStrings.length; ++i) {
            if (!mavStrings[i].equals(modifier)) continue;
            return true;
        }
        return false;
    }

    public void addModifier(String modifier) {
        if (!this.hasModifier(modifier)) {
            if (this._modifiersAndVisibility == null) {
                this.setMav(new ModifiersAndVisibility(SourceInfo.NO_INFO, new String[0]));
            }
            String[] modifiers = this._modifiersAndVisibility.getModifiers();
            String[] newModifiers = new String[modifiers.length + 1];
            newModifiers[0] = modifier;
            for (int i = 1; i <= modifiers.length; ++i) {
                newModifiers[i] = modifiers[i - 1];
            }
            this._modifiersAndVisibility = new ModifiersAndVisibility(this._modifiersAndVisibility.getSourceInfo(), newModifiers);
        }
    }

    public String createUniqueName(String varName) {
        int counter;
        VariableData vd = TypeChecker.getFieldOrVariable(varName, this, this.getSymbolData(), new NullLiteral(SourceInfo.NO_INFO), this.getVars(), true, false);
        String newName = varName;
        for (counter = 0; vd != null && counter != -1; ++counter) {
            newName = varName + counter;
            vd = TypeChecker.getFieldOrVariable(newName, this, this.getSymbolData(), new NullLiteral(SourceInfo.NO_INFO), this.getVars(), true, false);
        }
        if (counter == -1) {
            throw new RuntimeException("Internal Program Error: Unable to rename variable " + varName + ".  All possible names were taken.  Please report this bug");
        }
        return newName;
    }

    static /* synthetic */ boolean access$000(Data x0, VariableData x1) {
        return x0._repeatedName(x1);
    }
}

