/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.symbol;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.EvaluatorException;
import edu.rice.cs.dynamicjava.interpreter.RuntimeBindings;
import edu.rice.cs.dynamicjava.symbol.Access;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.DJConstructor;
import edu.rice.cs.dynamicjava.symbol.DJField;
import edu.rice.cs.dynamicjava.symbol.DJMethod;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.type.SimpleArrayType;
import edu.rice.cs.dynamicjava.symbol.type.SimpleClassType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.VariableType;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Box;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.LazyThunk;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.reflect.ReflectUtil;
import edu.rice.cs.plt.tuple.Option;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClass
implements DJClass {
    protected Class<?> _c;
    private static final Lambda<Class, Type> CLASS_AS_TYPE = new Lambda<Class, Type>(){

        @Override
        public Type value(Class c) {
            return JavaClass.classAsType(c);
        }
    };
    private static final Lambda<Class, DJClass> CONVERT_CLASS = new Lambda<Class, DJClass>(){

        @Override
        public DJClass value(Class c) {
            return new JavaClass(c);
        }
    };
    private final Lambda<Field, DJField> CONVERT_FIELD = new Lambda<Field, DJField>(){

        @Override
        public DJField value(Field f) {
            return new JavaField(f);
        }
    };
    private final Lambda<Constructor, DJConstructor> CONVERT_CONSTRUCTOR = new Lambda<Constructor, DJConstructor>(){

        @Override
        public DJConstructor value(Constructor k) {
            return new JavaConstructor(k);
        }
    };
    private final Lambda<Method, DJMethod> CONVERT_METHOD = new Lambda<Method, DJMethod>(){

        @Override
        public DJMethod value(Method m) {
            return new JavaMethod(m);
        }
    };
    private static final String[] FIELD_GET_EXTRA_STACK = new String[]{"java.lang.reflect.Field.get", "java.lang.reflect.Field.getFieldAccessor", "java.lang.reflect.Field.acquireFieldAccessor", "sun.reflect.ReflectionFactory.newFieldAccessor", "sun.reflect.UnsafeFieldAccessorFactory.newFieldAccessor", "sun.misc.Unsafe.ensureClassInitialized"};
    private static final String[] FIELD_SET_EXTRA_STACK = new String[]{"java.lang.reflect.Field.set", "java.lang.reflect.Field.getFieldAccessor", "java.lang.reflect.Field.acquireFieldAccessor", "sun.reflect.ReflectionFactory.newFieldAccessor", "sun.reflect.UnsafeFieldAccessorFactory.newFieldAccessor", "sun.misc.Unsafe.ensureClassInitialized"};
    private static final String[] CONSTRUCTOR_EXTRA_STACK = new String[]{"java.lang.reflect.Constructor.newInstance", "sun.reflect.DelegatingConstructorAccessorImpl.newInstance", "sun.reflect.NativeConstructorAccessorImpl.newInstance", "sun.reflect.NativeConstructorAccessorImpl.newInstance0"};
    private static final String[] METHOD_EXTRA_STACK = new String[]{"java.lang.reflect.Method.invoke", "sun.reflect.DelegatingMethodAccessorImpl.invoke", "sun.reflect.NativeMethodAccessorImpl.invoke", "sun.reflect.NativeMethodAccessorImpl.invoke0"};

    public JavaClass(Class<?> c) {
        this._c = c;
    }

    @Override
    public String packageName() {
        String name = this._c.getName();
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return "";
        }
        return name.substring(0, dot);
    }

    @Override
    public String fullName() {
        return this._c.getName();
    }

    @Override
    public boolean isAnonymous() {
        return ReflectUtil.isAnonymousClass(this._c);
    }

    @Override
    public String declaredName() {
        if (ReflectUtil.isAnonymousClass(this._c)) {
            throw new IllegalArgumentException("Anonymous class has no declared name");
        }
        return ReflectUtil.simpleName(this._c);
    }

    @Override
    public boolean isInterface() {
        return Modifier.isInterface(this._c.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this._c.getModifiers());
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this._c.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this._c.getModifiers());
    }

    @Override
    public Access accessibility() {
        return JavaClass.extractAccessibility(this._c.getModifiers());
    }

    @Override
    public boolean hasRuntimeBindingsParams() {
        return false;
    }

    @Override
    public Access.Module accessModule() {
        Class<?> result = this._c;
        Class<?> outer = result.getDeclaringClass();
        while (outer != null) {
            result = outer;
            outer = result.getDeclaringClass();
        }
        return new JavaClass(result);
    }

    @Override
    public DJClass declaringClass() {
        Class<?> outer = this._c.getDeclaringClass();
        return outer == null ? null : new JavaClass(outer);
    }

    @Override
    public Iterable<VariableType> declaredTypeParameters() {
        return IterUtil.empty();
    }

    @Override
    public Iterable<Type> declaredSupertypes() {
        Type superC = this.immediateSuperclass();
        AbstractIterable superIs = this._c.getInterfaces() == null ? IterUtil.empty() : IterUtil.mapSnapshot(IterUtil.asIterable(this._c.getInterfaces()), CLASS_AS_TYPE);
        return superC == null ? superIs : IterUtil.compose(superC, superIs);
    }

    @Override
    public Iterable<DJField> declaredFields() {
        return IterUtil.mapSnapshot(IterUtil.asIterable(this._c.getDeclaredFields()), this.CONVERT_FIELD);
    }

    @Override
    public Iterable<DJConstructor> declaredConstructors() {
        return IterUtil.mapSnapshot(IterUtil.asIterable(this._c.getDeclaredConstructors()), this.CONVERT_CONSTRUCTOR);
    }

    @Override
    public Iterable<DJMethod> declaredMethods() {
        return IterUtil.mapSnapshot(IterUtil.asIterable(this._c.getDeclaredMethods()), this.CONVERT_METHOD);
    }

    @Override
    public Iterable<DJClass> declaredClasses() {
        return IterUtil.mapSnapshot(IterUtil.asIterable(this._c.getDeclaredClasses()), CONVERT_CLASS);
    }

    @Override
    public Type immediateSuperclass() {
        Class<?> superT = this._c.getSuperclass();
        return superT == null ? null : JavaClass.classAsType(superT);
    }

    @Override
    public Class<?> load() {
        return this._c;
    }

    public String toString() {
        return "JavaClass(" + this._c.getName() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        return this._c.equals(((JavaClass)o)._c);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() << 1 ^ this._c.hashCode();
    }

    private static Type classAsType(Class<?> c) {
        if (c.isPrimitive()) {
            return SymbolUtil.typeOfPrimitiveClass(c);
        }
        if (c.isArray()) {
            return new SimpleArrayType(JavaClass.classAsType(c.getComponentType()));
        }
        return new SimpleClassType(new JavaClass(c));
    }

    private static Thunk<Iterable<LocalVariable>> paramFactory(final Class<?>[] cs) {
        return LazyThunk.make(new Thunk<Iterable<LocalVariable>>(){

            @Override
            public Iterable<LocalVariable> value() {
                ArrayList<LocalVariable> result = new ArrayList<LocalVariable>(cs.length);
                int argNum = 1;
                for (Class c : cs) {
                    result.add(new LocalVariable("a" + argNum++, JavaClass.classAsType(c), false));
                }
                return IterUtil.asSizedIterable(result);
            }
        });
    }

    private static Access extractAccessibility(int mods) {
        if (Modifier.isPublic(mods)) {
            return Access.PUBLIC;
        }
        if (Modifier.isProtected(mods)) {
            return Access.PROTECTED;
        }
        if (Modifier.isPrivate(mods)) {
            return Access.PRIVATE;
        }
        return Access.PACKAGE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JavaMethod
    implements DJMethod {
        protected final Method _m;
        private final Thunk<Iterable<LocalVariable>> _params;

        public JavaMethod(Method m) {
            this._m = m;
            this._params = this.makeParamThunk();
        }

        protected Thunk<Iterable<LocalVariable>> makeParamThunk() {
            return JavaClass.paramFactory(this._m.getParameterTypes());
        }

        @Override
        public String declaredName() {
            return this._m.getName();
        }

        @Override
        public DJClass declaringClass() {
            return JavaClass.this;
        }

        @Override
        public boolean isStatic() {
            return Modifier.isStatic(this._m.getModifiers());
        }

        @Override
        public boolean isAbstract() {
            return Modifier.isAbstract(this._m.getModifiers());
        }

        @Override
        public boolean isFinal() {
            return Modifier.isFinal(this._m.getModifiers());
        }

        @Override
        public Access accessibility() {
            return JavaClass.extractAccessibility(this._m.getModifiers());
        }

        @Override
        public Access.Module accessModule() {
            return JavaClass.this.accessModule();
        }

        @Override
        public Type returnType() {
            return JavaClass.classAsType(this._m.getReturnType());
        }

        @Override
        public Iterable<VariableType> typeParameters() {
            return IterUtil.empty();
        }

        @Override
        public Iterable<LocalVariable> parameters() {
            return this._params.value();
        }

        @Override
        public Iterable<Type> thrownTypes() {
            return IterUtil.mapSnapshot(IterUtil.asIterable(this._m.getExceptionTypes()), CLASS_AS_TYPE);
        }

        @Override
        public DJMethod declaredSignature() {
            return this;
        }

        @Override
        public Object evaluate(Object receiver, Iterable<Object> args, RuntimeBindings bindings, Options options) throws EvaluatorException {
            if (!this.isStatic() && receiver == null) {
                throw new WrappedException(new EvaluatorException(new NullPointerException()));
            }
            try {
                this._m.setAccessible(true);
            }
            catch (SecurityException e) {
                DebugUtil.debug.log(e);
            }
            Object[] argsArray = IterUtil.toArray(args, Object.class);
            try {
                return this._m.invoke(receiver, argsArray);
            }
            catch (InvocationTargetException e) {
                throw new EvaluatorException(e.getCause(), METHOD_EXTRA_STACK);
            }
            catch (LinkageError e) {
                throw new EvaluatorException((Throwable)e, METHOD_EXTRA_STACK);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (Throwable t) {
                throw new EvaluatorException(t, METHOD_EXTRA_STACK);
            }
        }

        public String toString() {
            return "JavaMethod(" + this.declaredName() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JavaConstructor
    implements DJConstructor {
        protected final Constructor<?> _k;
        protected final Type _outerType;
        private final Thunk<Iterable<LocalVariable>> _params;

        public JavaConstructor(Constructor<?> k) {
            this._k = k;
            DJClass outer = SymbolUtil.dynamicOuterClass(JavaClass.this);
            this._outerType = outer == null ? null : SymbolUtil.thisType(outer);
            this._params = this.makeParamThunk();
        }

        @Override
        public String declaredName() {
            return JavaClass.this.isAnonymous() ? "<anonymous>" : JavaClass.this.declaredName();
        }

        @Override
        public DJClass declaringClass() {
            return JavaClass.this;
        }

        @Override
        public Access accessibility() {
            return JavaClass.extractAccessibility(this._k.getModifiers());
        }

        @Override
        public Access.Module accessModule() {
            return JavaClass.this.accessModule();
        }

        protected Thunk<Iterable<LocalVariable>> makeParamThunk() {
            return JavaClass.paramFactory(this._k.getParameterTypes());
        }

        @Override
        public Iterable<VariableType> typeParameters() {
            return IterUtil.empty();
        }

        @Override
        public DJConstructor declaredSignature() {
            return this;
        }

        @Override
        public Iterable<LocalVariable> parameters() {
            Iterable<LocalVariable> result = this._params.value();
            if (this._outerType != null) {
                result = IterUtil.skipFirst(result);
            }
            return result;
        }

        @Override
        public Type returnType() {
            return SymbolUtil.thisType(JavaClass.this);
        }

        @Override
        public Iterable<Type> thrownTypes() {
            return IterUtil.mapSnapshot(IterUtil.asIterable(this._k.getExceptionTypes()), CLASS_AS_TYPE);
        }

        @Override
        public Object evaluate(Object outer, Iterable<Object> args, RuntimeBindings bindings, Options options) throws EvaluatorException {
            if (this._outerType != null) {
                if (outer == null) {
                    throw new WrappedException(new EvaluatorException(new NullPointerException()));
                }
                args = IterUtil.compose(outer, args);
            }
            try {
                this._k.setAccessible(true);
            }
            catch (SecurityException e) {
                DebugUtil.debug.log(e);
            }
            Object[] argsArray = IterUtil.toArray(args, Object.class);
            try {
                return this._k.newInstance(argsArray);
            }
            catch (InvocationTargetException e) {
                throw new EvaluatorException(e.getCause(), CONSTRUCTOR_EXTRA_STACK);
            }
            catch (LinkageError e) {
                throw new EvaluatorException((Throwable)e, CONSTRUCTOR_EXTRA_STACK);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (Throwable t) {
                throw new EvaluatorException(t, METHOD_EXTRA_STACK);
            }
        }

        public String toString() {
            return "JavaConstructor(" + this.declaredName() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JavaField
    implements DJField {
        protected final Field _f;

        public JavaField(Field f) {
            this._f = f;
        }

        @Override
        public String declaredName() {
            return this._f.getName();
        }

        @Override
        public DJClass declaringClass() {
            return JavaClass.this;
        }

        @Override
        public Type type() {
            return JavaClass.classAsType(this._f.getType());
        }

        @Override
        public boolean isFinal() {
            return Modifier.isFinal(this._f.getModifiers());
        }

        @Override
        public boolean isStatic() {
            return Modifier.isStatic(this._f.getModifiers());
        }

        @Override
        public Access accessibility() {
            return JavaClass.extractAccessibility(this._f.getModifiers());
        }

        @Override
        public Access.Module accessModule() {
            return JavaClass.this.accessModule();
        }

        @Override
        public Option<Object> constantValue() {
            if (this.isStatic() && this.isFinal() && (this._f.getType().isPrimitive() || this._f.getType().equals(String.class))) {
                try {
                    return Option.some(this.boxForReceiver(null).value());
                }
                catch (WrappedException e) {
                    return Option.none();
                }
            }
            return Option.none();
        }

        @Override
        public Box<Object> boxForReceiver(final Object receiver) {
            return new Box<Object>(){

                @Override
                public Object value() {
                    if (!JavaField.this.isStatic() && receiver == null) {
                        throw new WrappedException(new EvaluatorException(new NullPointerException()));
                    }
                    try {
                        JavaField.this._f.setAccessible(true);
                    }
                    catch (SecurityException e) {
                        DebugUtil.debug.log(e);
                    }
                    try {
                        return JavaField.this._f.get(receiver);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (LinkageError e) {
                        throw new WrappedException(new EvaluatorException((Throwable)e, FIELD_GET_EXTRA_STACK));
                    }
                    catch (Throwable t) {
                        throw new WrappedException(new EvaluatorException(t, FIELD_GET_EXTRA_STACK));
                    }
                }

                @Override
                public void set(Object o) {
                    if (!JavaField.this.isStatic() && receiver == null) {
                        throw new WrappedException(new EvaluatorException(new NullPointerException()));
                    }
                    try {
                        JavaField.this._f.setAccessible(true);
                    }
                    catch (SecurityException e) {
                        DebugUtil.debug.log(e);
                    }
                    try {
                        JavaField.this._f.set(receiver, o);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (LinkageError e) {
                        throw new WrappedException(new EvaluatorException((Throwable)e, FIELD_SET_EXTRA_STACK));
                    }
                    catch (Throwable t) {
                        throw new WrappedException(new EvaluatorException(t, FIELD_SET_EXTRA_STACK));
                    }
                }
            };
        }

        public String toString() {
            return "JavaField(" + this.declaredName() + ")";
        }
    }
}

