/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.interpreter.AmbiguousNameException;
import edu.rice.cs.dynamicjava.interpreter.DelegatingContext;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.symbol.Access;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.VariableType;
import edu.rice.cs.plt.debug.DebugUtil;

public class ClassSignatureContext
extends DelegatingContext {
    private DJClass _c;
    private ClassLoader _loader;

    public ClassSignatureContext(TypeContext next, DJClass c, ClassLoader loader) {
        super(next);
        this._c = c;
        this._loader = loader;
    }

    protected ClassSignatureContext duplicate(TypeContext next) {
        return new ClassSignatureContext(next, this._c, this._loader);
    }

    public boolean typeExists(String name, TypeSystem ts) {
        return this.matchesClass(name) || this.matchesTypeVariable(name) || super.typeExists(name, ts);
    }

    private boolean matchesTopLevelClass(String name) {
        return !this._c.isAnonymous() && this._c.declaringClass() == null && this._c.declaredName().equals(name);
    }

    private boolean matchesMemberClass(String name) {
        return !this._c.isAnonymous() && this._c.declaringClass() != null && this._c.declaredName().equals(name);
    }

    private boolean matchesClass(String name) {
        return !this._c.isAnonymous() && this._c.declaredName().equals(name);
    }

    private boolean matchesTypeVariable(String name) {
        return this.declaredTypeVariable(name) != null;
    }

    private VariableType declaredTypeVariable(String name) {
        for (VariableType t : this._c.declaredTypeParameters()) {
            if (!t.symbol().name().equals(name)) continue;
            return t;
        }
        return null;
    }

    public boolean topLevelClassExists(String name, TypeSystem ts) {
        return this.matchesTopLevelClass(name) || !this.matchesMemberClass(name) && !this.matchesTypeVariable(name) && super.topLevelClassExists(name, ts);
    }

    public DJClass getTopLevelClass(String name, TypeSystem ts) throws AmbiguousNameException {
        if (this.matchesTopLevelClass(name)) {
            return this._c;
        }
        if (!this.matchesMemberClass(name) && !this.matchesTypeVariable(name)) {
            return super.getTopLevelClass(name, ts);
        }
        return null;
    }

    public boolean memberClassExists(String name, TypeSystem ts) {
        return this.matchesMemberClass(name) || !this.matchesTopLevelClass(name) && !this.matchesTypeVariable(name) && super.memberClassExists(name, ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassType typeContainingMemberClass(String name, TypeSystem ts) throws AmbiguousNameException {
        DebugUtil.debug.logStart(new String[]{"class", "name"}, this._c, name);
        try {
            if (this.matchesMemberClass(name)) {
                ClassType classType = SymbolUtil.thisType(this._c.declaringClass());
                return classType;
            }
            if (!this.matchesTopLevelClass(name) && !this.matchesTypeVariable(name)) {
                ClassType classType = super.typeContainingMemberClass(name, ts);
                return classType;
            }
            ClassType classType = null;
            return classType;
        }
        finally {
            DebugUtil.debug.logEnd();
        }
    }

    public boolean typeVariableExists(String name, TypeSystem ts) {
        return this.matchesTypeVariable(name) || !this.matchesClass(name) && super.typeVariableExists(name, ts);
    }

    public VariableType getTypeVariable(String name, TypeSystem ts) {
        VariableType result = this.declaredTypeVariable(name);
        if (result != null) {
            return result;
        }
        if (!this.matchesClass(name)) {
            return super.getTypeVariable(name, ts);
        }
        return null;
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public Access.Module accessModule() {
        return this._c.accessModule();
    }
}

