/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.ColorOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import edu.rice.cs.util.swing.SwingFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorOptionComponent
extends OptionComponent<Color, JPanel> {
    private JButton _button;
    private JTextField _colorField;
    private JPanel _panel;
    private Color _color;
    private boolean _isBackgroundColor;
    private boolean _isBoldText;

    public ColorOptionComponent(ColorOption opt, String text, SwingFrame parent) {
        this(opt, text, parent, false);
    }

    public ColorOptionComponent(ColorOption opt, String text, SwingFrame parent, boolean isBackgroundColor) {
        this(opt, text, parent, isBackgroundColor, false);
    }

    public ColorOptionComponent(ColorOption opt, String text, SwingFrame parent, boolean isBackgroundColor, boolean isBoldText) {
        super(opt, text, parent);
        this._isBackgroundColor = isBackgroundColor;
        this._isBoldText = isBoldText;
        this._button = new JButton();
        this._button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorOptionComponent.this.chooseColor();
            }
        });
        this._button.setText("...");
        this._button.setMaximumSize(new Dimension(10, 10));
        this._button.setMinimumSize(new Dimension(10, 10));
        this._colorField = new JTextField();
        this._colorField.setEditable(false);
        this._colorField.setHorizontalAlignment(0);
        this._panel = new JPanel(new BorderLayout());
        this._panel.add((Component)this._colorField, "Center");
        this._panel.add((Component)this._button, "East");
        if (this._isBackgroundColor) {
            this._colorField.setForeground(DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_NORMAL_COLOR));
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_NORMAL_COLOR, new OptionListener<Color>(){

                @Override
                public void optionChanged(OptionEvent<Color> oe) {
                    ColorOptionComponent.this._colorField.setForeground((Color)oe.value);
                }
            });
        } else {
            this._colorField.setBackground(DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_BACKGROUND_COLOR));
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_BACKGROUND_COLOR, new OptionListener<Color>(){

                @Override
                public void optionChanged(OptionEvent<Color> oe) {
                    ColorOptionComponent.this._colorField.setBackground((Color)oe.value);
                }
            });
        }
        if (this._isBoldText) {
            this._colorField.setFont(this._colorField.getFont().deriveFont(1));
        }
        this._color = (Color)DrJava.getConfig().getSetting(this._option);
        this._updateField(this._color);
        this.setComponent(this._panel);
    }

    public ColorOptionComponent(ColorOption opt, String text, SwingFrame parent, String description) {
        this(opt, text, parent, description, false);
    }

    public ColorOptionComponent(ColorOption opt, String text, SwingFrame parent, String description, boolean isBackgroundColor) {
        this(opt, text, parent, isBackgroundColor);
        this.setDescription(description);
    }

    public ColorOptionComponent(ColorOption opt, String text, SwingFrame parent, String description, boolean isBackgroundColor, boolean isBoldText) {
        this(opt, text, parent, isBackgroundColor, isBoldText);
        this.setDescription(description);
    }

    @Override
    public void setDescription(String description) {
        this._panel.setToolTipText(description);
        this._button.setToolTipText(description);
        this._colorField.setToolTipText(description);
        this._label.setToolTipText(description);
    }

    @Override
    public boolean updateConfig() {
        if (!this._color.equals(DrJava.getConfig().getSetting(this._option))) {
            DrJava.getConfig().setSetting(this._option, this._color);
        }
        return true;
    }

    @Override
    public void setValue(Color value) {
        this._color = value;
        this._updateField(value);
    }

    private void _updateField(Color c) {
        if (this._isBackgroundColor) {
            this._colorField.setBackground(c);
        } else {
            this._colorField.setForeground(c);
        }
        this._colorField.setText(this.getLabelText() + " (" + this._option.format(c) + ")");
    }

    public void chooseColor() {
        Color c = JColorChooser.showDialog(this._parent, "Choose '" + this.getLabelText() + "'", this._color);
        if (c != null) {
            this._color = c;
            this.notifyChangeListeners();
            this._updateField(c);
        }
    }
}

