/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.DrJavaFileUtils;
import edu.rice.cs.drjava.ui.JavaSourceFilter;
import java.io.File;

public class SmartSourceFilter
extends JavaSourceFilter {
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String name = f.getName();
        if (DrJavaFileUtils.isLLFile(name)) {
            return true;
        }
        if (!name.endsWith(".java")) {
            return false;
        }
        File parent = f.getParentFile();
        if (parent == null) {
            return true;
        }
        if (new File(parent, DrJavaFileUtils.getDJForJavaFile(name)).exists()) {
            return false;
        }
        if (new File(parent, DrJavaFileUtils.getDJ0ForJavaFile(name)).exists()) {
            return false;
        }
        if (new File(parent, DrJavaFileUtils.getDJ1ForJavaFile(name)).exists()) {
            return false;
        }
        return !new File(parent, DrJavaFileUtils.getDJ2ForJavaFile(name)).exists();
    }

    public String getDescription() {
        return "DrJava source files (*.java, *.dj, *.dj0, *.dj1, *.dj2)";
    }
}

