/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.ui.DefinitionsPane;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.util.swing.DisplayManager;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JWindow;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class RecentDocFrame
extends JWindow {
    MainFrame _frame;
    DisplayManager<OpenDefinitionsDocument> _displayManager = MainFrame.getOddDisplayManager30();
    JLabel _label;
    JPanel _panel;
    JTextPane _textpane;
    JScrollPane _scroller;
    int _current = 0;
    int _padding = 4;
    LinkedList<OpenDefinitionsDocument> _docs = new LinkedList();
    private OptionListener<Color> _colorListener = new OptionListener<Color>(){

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            RecentDocFrame.this.updateFontColor();
        }
    };
    private OptionListener<Font> _fontListener = new OptionListener<Font>(){

        @Override
        public void optionChanged(OptionEvent<Font> oce) {
            RecentDocFrame.this.updateFontColor();
        }
    };
    private OptionListener<Boolean> _antialiasListener = new OptionListener<Boolean>(){

        @Override
        public void optionChanged(OptionEvent<Boolean> oce) {
            RecentDocFrame.this.updateFontColor();
        }
    };
    private OptionListener<Boolean> _showSourceListener = new OptionListener<Boolean>(){

        @Override
        public void optionChanged(OptionEvent<Boolean> oce) {
            RecentDocFrame.this._showSource = (Boolean)oce.value;
        }
    };
    boolean _antiAliasText = false;
    boolean _showSource;

    public RecentDocFrame(MainFrame f) {
        this._frame = f;
        this._current = 0;
        this._label = new JLabel("..."){

            protected void paintComponent(Graphics g) {
                if (RecentDocFrame.this._antiAliasText && g instanceof Graphics2D) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
                super.paintComponent(g);
            }
        };
        this._panel = new JPanel();
        this._scroller = new JScrollPane();
        this._textpane = new JTextPane(){

            protected void paintComponent(Graphics g) {
                if (RecentDocFrame.this._antiAliasText && g instanceof Graphics2D) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
                super.paintComponent(g);
            }
        };
        this._textpane.setText("...");
        this._scroller.getViewport().add(this._textpane);
        this._scroller.setVerticalScrollBarPolicy(21);
        this._scroller.setHorizontalScrollBarPolicy(31);
        this._scroller.setMaximumSize(new Dimension(300, 200));
        this._panel.setLayout(new BorderLayout());
        this._panel.add((Component)this._label, "North");
        this._panel.add((Component)this._scroller, "South");
        this.getContentPane().add(this._panel);
        this.pack();
        this.updateFontColor();
        this._showSource = DrJava.getConfig().getSetting(OptionConstants.SHOW_SOURCE_WHEN_SWITCHING);
        DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_BACKGROUND_COLOR, this._colorListener);
        DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_NORMAL_COLOR, this._colorListener);
        DrJava.getConfig().addOptionListener(OptionConstants.FONT_MAIN, this._fontListener);
        DrJava.getConfig().addOptionListener(OptionConstants.TEXT_ANTIALIAS, this._antialiasListener);
        DrJava.getConfig().addOptionListener(OptionConstants.SHOW_SOURCE_WHEN_SWITCHING, this._showSourceListener);
    }

    private void updateFontColor() {
        Font mainFont = DrJava.getConfig().getSetting(OptionConstants.FONT_MAIN);
        Color backColor = DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_BACKGROUND_COLOR);
        Color fontColor = DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_NORMAL_COLOR);
        Font titleFont = mainFont.deriveFont((float)(mainFont.getSize() + 3));
        this._antiAliasText = DrJava.getConfig().getSetting(OptionConstants.TEXT_ANTIALIAS);
        this._label.setForeground(fontColor);
        this._panel.setBackground(backColor);
        this._label.setFont(titleFont);
        this._textpane.setForeground(fontColor);
        this._textpane.setFont(mainFont);
        this._textpane.setBackground(backColor);
        this._scroller.setBackground(backColor);
        this._scroller.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._panel.setBorder(new LineBorder(fontColor, 1));
    }

    public void pokeDocument(OpenDefinitionsDocument d) {
        if (this._docs.contains(d)) {
            this._current = this._docs.indexOf(d);
            this.reset();
        } else {
            this._docs.addFirst(d);
        }
    }

    public void closeDocument(OpenDefinitionsDocument d) {
        this._docs.remove(d);
    }

    private void show(int _current) {
        OpenDefinitionsDocument doc = this._docs.get(_current);
        String text = this.getTextFor(doc);
        this._label.setText(this._displayManager.getName(doc));
        this._label.setIcon(this._displayManager.getIcon(doc));
        if (text.length() > 0) {
            this._textpane.setText(text);
            this._scroller.setPreferredSize(this._textpane.getPreferredScrollableViewportSize());
            if (this._scroller.getPreferredSize().getHeight() > 200.0) {
                this._scroller.setPreferredSize(new Dimension((int)this._scroller.getPreferredSize().getWidth(), 200));
            }
            this._scroller.setVisible(this._showSource);
        } else {
            this._scroller.setVisible(false);
        }
        Dimension d = this._label.getMinimumSize();
        d.setSize(d.getWidth() + (double)(this._padding * 2), d.getHeight() + (double)(this._padding * 2));
        this._label.setPreferredSize(d);
        this._label.setHorizontalAlignment(0);
        this._label.setVerticalAlignment(0);
        this.pack();
        this.centerH();
    }

    public void next() {
        if (this._docs.size() > 0) {
            ++this._current;
            if (this._current >= this._docs.size()) {
                this._current = 0;
            }
            this.show(this._current);
        }
    }

    public void prev() {
        if (this._docs.size() > 0) {
            --this._current;
            if (this._current < 0) {
                this._current = this._docs.size() - 1;
            }
            this.show(this._current);
        }
    }

    private String getTextFor(OpenDefinitionsDocument doc) {
        int loc;
        DefinitionsPane pane = this._frame.getDefPaneGivenODD(doc);
        String endl = "\n";
        int start = loc = pane.getCaretPosition();
        int end = loc;
        String text = doc.getText();
        for (int i = 0; i < 4; ++i) {
            if (start <= 0) continue;
            start = text.lastIndexOf(endl, start - endl.length());
        }
        if (start == -1) {
            start = 0;
        }
        if (doc.getLength() >= endl.length() && text.substring(start, start + endl.length()).equals(endl)) {
            start += endl.length();
        }
        for (int i = 0; i < 4; ++i) {
            int index;
            if (end >= doc.getLength() || (index = text.indexOf(endl, end + endl.length())) == -1) continue;
            end = index;
        }
        if (end < start) {
            end = start;
        }
        text = text.substring(start, end);
        return text;
    }

    public void first() {
        this._current = 0;
        this.next();
    }

    public void refreshColor() {
    }

    public void setVisible(boolean v) {
        this.centerH();
        if (this._docs.size() > 0) {
            if (v) {
                this.centerV();
                this.refreshColor();
                this.first();
            } else {
                this.reset();
            }
            super.setVisible(v);
        }
    }

    private void centerH() {
        Utilities.setPopupLoc(this, this._frame);
    }

    private void centerV() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        this.setLocation((int)this.getLocation().getX(), (screenSize.height - frameSize.height) / 2);
    }

    public void reset() {
        if (this._current < this._docs.size()) {
            this._docs.addFirst(this._docs.remove(this._current));
        }
    }

    public OpenDefinitionsDocument getDocument() {
        if (this._docs.size() > 0) {
            return this._docs.getFirst();
        }
        return null;
    }
}

