/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.project;

import edu.rice.cs.drjava.model.DummyDocumentRegion;
import edu.rice.cs.drjava.model.FileRegion;
import edu.rice.cs.drjava.model.debug.DebugBreakpointData;
import edu.rice.cs.drjava.model.debug.DebugWatchData;
import edu.rice.cs.drjava.project.DocFile;
import edu.rice.cs.drjava.project.MalformedProjectFileException;
import edu.rice.cs.drjava.project.ProjectFileIR;
import edu.rice.cs.drjava.project.ProjectFileParserFacade;
import edu.rice.cs.drjava.project.ProjectProfile;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.AbsRelFile;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.XMLConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLProjectFileParser
extends ProjectFileParserFacade {
    public static final XMLProjectFileParser ONLY = new XMLProjectFileParser();
    protected String _parent;
    protected String _srcFileBase;
    protected XMLConfig _xc;
    static Log LOG = new Log("xmlparser.log", false);

    private XMLProjectFileParser() {
        this._xmlProjectFile = true;
    }

    @Override
    public ProjectFileIR parse(File projFile) throws IOException, FileNotFoundException, MalformedProjectFileException {
        this._projectFile = projFile;
        this._srcFileBase = this._parent = projFile.getParent();
        ProjectProfile pfir = new ProjectProfile(projFile);
        try {
            String s;
            XMLConfig xcParent = new XMLConfig(projFile);
            String version = xcParent.get("drjava.version", "unknown");
            LOG.log("version = '" + version + "'");
            pfir.setDrJavaVersion(version);
            this._xc = new XMLConfig(xcParent, xcParent.getNodes("drjava/project").get(0));
            LOG.log(this._xc.toString());
            try {
                s = this._xc.get(".root");
                LOG.log("root = '" + s + "'");
                File root = new File(this._parent, s);
                LOG.log("_parent = " + this._parent);
                pfir.setProjectRoot(root);
                this._srcFileBase = root.getCanonicalPath();
                LOG.log("_srcFileBase from reading the prject root = " + this._srcFileBase);
            }
            catch (XMLConfig.XMLConfigException e) {
                throw new MalformedProjectFileException("XML Parse Error: " + e.getMessage() + "\n" + StringOps.getStackTrace(e));
            }
            try {
                s = this._xc.get("createjar.file");
                LOG.log("createjar.file = '" + s + "'");
                File jarFile = new File(this._parent, s);
                pfir.setCreateJarFile(jarFile);
            }
            catch (XMLConfig.XMLConfigException e) {
                // empty catch block
            }
            try {
                s = this._xc.get("createjar.flags");
                LOG.log("createjar.flags = '" + s + "'");
                int flags = Integer.valueOf(s);
                pfir.setCreateJarFlags(flags);
            }
            catch (XMLConfig.XMLConfigException e) {
                // empty catch block
            }
            try {
                s = this._xc.get(".manifest");
                LOG.log("manifest = '" + s + "'");
                pfir.setCustomManifest(TextUtil.xmlUnescape(s));
            }
            catch (XMLConfig.XMLConfigException e) {
                // empty catch block
            }
            try {
                s = this._xc.get(".build");
                LOG.log("build = '" + s + "'");
                File buildDir = !new File(s).isAbsolute() ? new File(this._parent, s) : new File(s);
                pfir.setBuildDirectory(buildDir);
            }
            catch (XMLConfig.XMLConfigException e) {
                // empty catch block
            }
            try {
                s = this._xc.get(".work");
                LOG.log("work = '" + s + "'");
                File workDir = !new File(s).isAbsolute() ? new File(this._parent, s) : new File(s);
                pfir.setWorkingDirectory(workDir);
            }
            catch (XMLConfig.XMLConfigException e) {
                throw new MalformedProjectFileException("XML Parse Error: " + e.getMessage() + "\n" + StringOps.getStackTrace(e));
            }
            try {
                s = this._xc.get(".main");
                LOG.log("main = '" + s + "'");
                pfir.setMainClass(s);
            }
            catch (XMLConfig.XMLConfigException e) {
                // empty catch block
            }
            try {
                s = this._xc.get(".autorefresh");
                boolean b = Boolean.valueOf(s);
                pfir.setAutoRefreshStatus(b);
            }
            catch (XMLConfig.XMLConfigException e) {
                // empty catch block
            }
            try {
                pfir.setSourceFiles(this.readSourceFiles("source", this._srcFileBase));
                pfir.setAuxiliaryFiles(this.readSourceFiles("included", ""));
                pfir.setExcludedFiles(this.readSourceFiles("excluded", ""));
                pfir.setCollapsedPaths(this.readCollapsed());
                pfir.setClassPaths(this.readFiles("classpath", this._srcFileBase));
                pfir.setBreakpoints(this.readBreakpoints());
                pfir.setWatches(this.readWatches());
                pfir.setBookmarks(this.readBookmarks());
            }
            catch (XMLConfig.XMLConfigException e) {
                throw new MalformedProjectFileException("XML Parse Error: " + e.getMessage() + "\n" + StringOps.getStackTrace(e));
            }
        }
        catch (XMLConfig.XMLConfigException e) {
            throw new MalformedProjectFileException("Malformed XML project file." + e.getMessage() + "\n" + StringOps.getStackTrace(e));
        }
        catch (NumberFormatException e) {
            throw new MalformedProjectFileException("Malformed XML project file; a value that should have been an integer was not.\n" + StringOps.getStackTrace(e));
        }
        catch (IllegalArgumentException e) {
            throw new MalformedProjectFileException("Malformed XML project file; a value had the wrong type.\n" + StringOps.getStackTrace(e));
        }
        catch (IndexOutOfBoundsException e) {
            throw new MalformedProjectFileException("Malformed XML project file; a required value was missing.\n" + StringOps.getStackTrace(e));
        }
        LOG.log(((Object)pfir).toString());
        return pfir;
    }

    protected List<DocFile> readSourceFiles(String path, String rootPath) throws MalformedProjectFileException {
        LOG.log("readSourceFiles(path='" + path + "', rootPath='" + rootPath + "')");
        ArrayList<DocFile> docFList = new ArrayList<DocFile>();
        List<Node> defs = this._xc.getNodes(path + "/file");
        LOG.log("\tdefs.size() = " + defs.size());
        for (Node n : defs) {
            LOG.log("\t" + n.getNodeValue());
        }
        for (Node n : defs) {
            boolean active;
            Date modDate;
            LOG.log("\t" + n.toString());
            String name = this._xc.get(".name", n);
            LOG.log("\t\tname = '" + name + "'");
            int selectFrom = this._xc.getInt("select.from", n);
            int selectTo = this._xc.getInt("select.to", n);
            LOG.log("\t\tselect = '" + selectFrom + " to " + selectTo + "'");
            int scrollCol = this._xc.getInt("scroll.column", n);
            int scrollRow = this._xc.getInt("scroll.row", n);
            LOG.log("\t\tscroll = '" + scrollCol + " , " + scrollRow + "'");
            String timestamp = this._xc.get(".timestamp", n);
            LOG.log("\t\ttimestamp = '" + timestamp + "'");
            try {
                modDate = ProjectProfile.MOD_DATE_FORMAT.parse(timestamp);
            }
            catch (ParseException e1) {
                try {
                    modDate = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").parse(timestamp);
                }
                catch (ParseException e2) {
                    throw new MalformedProjectFileException("Source file node contains badly formatted timestamp.");
                }
            }
            String pkg = this._xc.get(".package", n);
            LOG.log("\t\tpackage = '" + pkg + "'");
            try {
                active = this._xc.getBool(".active", n);
                LOG.log("\t\tactive = '" + active + "'");
            }
            catch (XMLConfig.XMLConfigException e) {
                active = false;
            }
            Boolean absName = new File(name).isAbsolute();
            DocFile docF = new DocFile((rootPath.length() > 0 && absName == false ? new File(rootPath, name) : new File(name)).getAbsoluteFile(), new Pair<Integer, Integer>(selectFrom, selectTo), new Pair<Integer, Integer>(scrollCol, scrollCol), active, pkg);
            docF.setSavedModDate(modDate.getTime());
            docFList.add(docF);
        }
        return docFList;
    }

    protected List<AbsRelFile> readFiles(String path) {
        return this.readFiles(path, "");
    }

    protected List<AbsRelFile> readFiles(String path, String rootPath) {
        ArrayList<AbsRelFile> fList = new ArrayList<AbsRelFile>();
        List<Node> defs = this._xc.getNodes(path + "/file");
        for (Node n : defs) {
            String name = this._xc.get(".name", n);
            boolean abs = this._xc.getBool(".absolute", n, true);
            AbsRelFile f = new AbsRelFile((rootPath.length() > 0 && !(abs |= new File(name).isAbsolute()) ? new File(rootPath, name) : new File(name)).getAbsoluteFile(), abs);
            fList.add(f);
        }
        return fList;
    }

    protected List<String> readCollapsed() {
        ArrayList<String> pList = new ArrayList<String>();
        List<Node> defs = this._xc.getNodes("collapsed/path");
        for (Node n : defs) {
            pList.add(this._xc.get(".name", n));
        }
        return pList;
    }

    protected List<DebugBreakpointData> readBreakpoints() {
        ArrayList<DebugBreakpointData> bpList = new ArrayList<DebugBreakpointData>();
        List<Node> defs = this._xc.getNodes("breakpoints/breakpoint");
        for (Node n : defs) {
            DebugBreakpointData dbd;
            File f;
            String name = this._xc.get(".file", n);
            final int lnr = this._xc.getInt(".line", n);
            final boolean enabled = this._xc.getBool(".enabled", n);
            if (this._srcFileBase == null || new File(name).isAbsolute()) {
                f = new File(name);
                dbd = new DebugBreakpointData(){

                    public File getFile() {
                        return f;
                    }

                    public int getLineNumber() {
                        return lnr;
                    }

                    public boolean isEnabled() {
                        return enabled;
                    }
                };
            } else {
                f = new File(this._srcFileBase, name);
                dbd = new DebugBreakpointData(){

                    public File getFile() {
                        return f;
                    }

                    public int getLineNumber() {
                        return lnr;
                    }

                    public boolean isEnabled() {
                        return enabled;
                    }
                };
            }
            bpList.add(dbd);
        }
        return bpList;
    }

    protected List<DebugWatchData> readWatches() {
        ArrayList<DebugWatchData> wList = new ArrayList<DebugWatchData>();
        List<Node> defs = this._xc.getNodes("watches/watch");
        for (Node n : defs) {
            wList.add(new DebugWatchData(this._xc.get(".name", n)));
        }
        return wList;
    }

    protected List<FileRegion> readBookmarks() {
        ArrayList<FileRegion> rList = new ArrayList<FileRegion>();
        List<Node> defs = this._xc.getNodes("bookmarks/bookmark");
        for (Node n : defs) {
            String name = this._xc.get(".file", n);
            int from = this._xc.getInt(".from", n);
            int to2 = this._xc.getInt(".to", n);
            File f = this._srcFileBase == null || new File(name).isAbsolute() ? new File(name) : new File(this._srcFileBase, name);
            rList.add(new DummyDocumentRegion(f, from, to2));
        }
        return rList;
    }
}

