/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.platform;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.prefs.Preferences;

public class WindowsRegistry {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int ERROR_UNKNOWN = -1;
    public static final int NULL_NATIVE_HANDLE = 0;
    public static final int DELETE = 65536;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_READ = 131097;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_ALL_ACCESS = 983103;
    private static final int NATIVE_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    private static final int SUBKEYS_NUMBER = 0;
    private static final int VALUES_NUMBER = 2;
    private static final int MAX_KEY_LENGTH = 3;
    private static final int MAX_VALUE_NAME_LENGTH = 4;
    private static final int DISPOSITION = 2;
    private static final int REG_CREATED_NEW_KEY = 1;
    private static final int REG_OPENED_EXISTING_KEY = 2;
    private static volatile boolean initialized = false;
    private static final Preferences userRoot = Preferences.userRoot();
    private static final Preferences systemRoot = Preferences.systemRoot();
    private static Class userClass = null;
    private static Class systemClass = null;
    private static Method windowsRegOpenKey = null;
    private static Method windowsRegCloseKey = null;
    private static Method windowsRegCreateKeyEx = null;
    private static Method windowsRegDeleteKey = null;
    private static Method windowsRegFlushKey = null;
    private static Method windowsRegQueryValueEx = null;
    private static Method windowsRegSetValueEx = null;
    private static Method windowsRegDeleteValue = null;
    private static Method windowsRegQueryInfoKey = null;
    private static Method windowsRegEnumKeyEx = null;
    private static Method windowsRegEnumValue = null;

    private static RegistryException newRegistryException(int error, int hive, String subKey) {
        if (error == 2) {
            return new RegistryKeyNotFoundException(hive, subKey);
        }
        if (error == 5) {
            return new RegistryKeyNotFoundException(hive, subKey);
        }
        return new RegistryException(error);
    }

    private static synchronized void initialize() throws NoSuchMethodException {
        if (initialized) {
            return;
        }
        initialized = true;
        userClass = userRoot.getClass();
        systemClass = systemRoot.getClass();
        windowsRegOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
        windowsRegOpenKey.setAccessible(true);
        windowsRegCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
        windowsRegCloseKey.setAccessible(true);
        windowsRegCreateKeyEx = userClass.getDeclaredMethod("WindowsRegCreateKeyEx", Integer.TYPE, byte[].class);
        windowsRegCreateKeyEx.setAccessible(true);
        windowsRegDeleteKey = userClass.getDeclaredMethod("WindowsRegDeleteKey", Integer.TYPE, byte[].class);
        windowsRegDeleteKey.setAccessible(true);
        windowsRegFlushKey = userClass.getDeclaredMethod("WindowsRegFlushKey", Integer.TYPE);
        windowsRegFlushKey.setAccessible(true);
        windowsRegQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
        windowsRegQueryValueEx.setAccessible(true);
        windowsRegSetValueEx = userClass.getDeclaredMethod("WindowsRegSetValueEx", Integer.TYPE, byte[].class, byte[].class);
        windowsRegSetValueEx.setAccessible(true);
        windowsRegDeleteValue = userClass.getDeclaredMethod("WindowsRegDeleteValue", Integer.TYPE, byte[].class);
        windowsRegDeleteValue.setAccessible(true);
        windowsRegQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey", Integer.TYPE);
        windowsRegQueryInfoKey.setAccessible(true);
        windowsRegEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        windowsRegEnumKeyEx.setAccessible(true);
        windowsRegEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        windowsRegEnumValue.setAccessible(true);
    }

    public static int openKey(int hKey, String subKey, int securityMask) throws RegistryException {
        int[] retval = null;
        try {
            WindowsRegistry.initialize();
            byte[] barr = WindowsRegistry.stringToNullTerminated(subKey);
            retval = (int[])windowsRegOpenKey.invoke((Object)systemRoot, hKey, barr, securityMask);
            if (retval.length != 2) {
                throw new AssertionError((Object)"Invalid array length.");
            }
            if (retval[1] != 0) {
                throw WindowsRegistry.newRegistryException(retval[1], hKey, subKey);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new RegistryException("Exception thrown in openKey", nsme);
        }
        catch (IllegalArgumentException iae) {
            throw new RegistryException("Exception thrown in openKey", iae);
        }
        catch (IllegalAccessException iae2) {
            throw new RegistryException("Exception thrown in openKey", iae2);
        }
        catch (InvocationTargetException ite) {
            throw new RegistryException("Exception thrown in openKey", ite);
        }
        return retval[0];
    }

    public static void closeKey(int hKey) throws RegistryException {
        try {
            WindowsRegistry.initialize();
            int retval = (Integer)windowsRegCloseKey.invoke((Object)systemRoot, hKey);
            if (retval != 0) {
                throw new RegistryException(retval);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new RegistryException("Exception thrown in closeKey", nsme);
        }
        catch (IllegalArgumentException iae) {
            throw new RegistryException("Exception thrown in closeKey", iae);
        }
        catch (IllegalAccessException iae2) {
            throw new RegistryException("Exception thrown in closeKey", iae2);
        }
        catch (InvocationTargetException ite) {
            throw new RegistryException("Exception thrown in closeKey", ite);
        }
    }

    public static CreateResult createKey(int hKey, String subKey) throws RegistryException {
        int[] retval = null;
        try {
            WindowsRegistry.initialize();
            byte[] barr = WindowsRegistry.stringToNullTerminated(subKey);
            retval = (int[])windowsRegCreateKeyEx.invoke((Object)systemRoot, hKey, barr);
            if (retval.length != 3) {
                throw new AssertionError((Object)"Invalid array length.");
            }
            if (retval[1] != 0) {
                throw WindowsRegistry.newRegistryException(retval[1], hKey, subKey);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new RegistryException("Exception thrown in createKey", nsme);
        }
        catch (IllegalArgumentException iae) {
            throw new RegistryException("Exception thrown in createKey", iae);
        }
        catch (IllegalAccessException iae2) {
            throw new RegistryException("Exception thrown in createKey", iae2);
        }
        catch (InvocationTargetException ite) {
            throw new RegistryException("Exception thrown in createKey", ite);
        }
        return new CreateResult(retval[0], retval[2] == 1);
    }

    public static void deleteKey(int hKey, String subKey) throws RegistryException {
        try {
            WindowsRegistry.initialize();
            byte[] barr = WindowsRegistry.stringToNullTerminated(subKey);
            int retval = (Integer)windowsRegDeleteKey.invoke((Object)systemRoot, hKey, barr);
            if (retval != 0) {
                throw WindowsRegistry.newRegistryException(retval, hKey, subKey);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new RegistryException("Exception thrown in deleteKey", nsme);
        }
        catch (IllegalArgumentException iae) {
            throw new RegistryException("Exception thrown in deleteKey", iae);
        }
        catch (IllegalAccessException iae2) {
            throw new RegistryException("Exception thrown in deleteKey", iae2);
        }
        catch (InvocationTargetException ite) {
            throw new RegistryException("Exception thrown in deleteKey", ite);
        }
    }

    public static void flushKey(int hKey) throws RegistryException {
        try {
            WindowsRegistry.initialize();
            int retval = (Integer)windowsRegFlushKey.invoke((Object)systemRoot, hKey);
            if (retval != 0) {
                throw new RegistryException(retval);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new RegistryException("Exception thrown in flushKey", nsme);
        }
        catch (IllegalArgumentException iae) {
            throw new RegistryException("Exception thrown in flushKey", iae);
        }
        catch (IllegalAccessException iae2) {
            throw new RegistryException("Exception thrown in flushKey", iae2);
        }
        catch (InvocationTargetException ite) {
            throw new RegistryException("Exception thrown in flushKey", ite);
        }
    }

    public static String queryValue(int hKey, String valueName) throws RegistryException {
        byte[] retval = null;
        try {
            WindowsRegistry.initialize();
            byte[] barr = WindowsRegistry.stringToNullTerminated(valueName);
            retval = (byte[])windowsRegQueryValueEx.invoke((Object)systemRoot, hKey, barr);
        }
        catch (NoSuchMethodException nsme) {
            throw new RegistryException("Exception thrown in queryValue", nsme);
        }
        catch (IllegalArgumentException iae) {
            throw new RegistryException("Exception thrown in queryValue", iae);
        }
        catch (IllegalAccessException iae2) {
            throw new RegistryException("Exception thrown in queryValue", iae2);
        }
        catch (InvocationTargetException ite) {
            throw new RegistryException("Exception thrown in queryValue", ite);
        }
        return WindowsRegistry.nullTerminatedToString(retval);
    }

    public static void setValue(int hKey, String valueName, String value) throws RegistryException {
        try {
            WindowsRegistry.initialize();
            byte[] barrName = WindowsRegistry.stringToNullTerminated(valueName);
            byte[] barrValue = WindowsRegistry.stringToNullTerminated(value);
            int retval = (Integer)windowsRegSetValueEx.invoke((Object)systemRoot, hKey, barrName, barrValue);
            if (retval != 0) {
                throw new RegistryException(retval);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new RegistryException("Exception thrown in setValue", nsme);
        }
        catch (IllegalArgumentException iae) {
            throw new RegistryException("Exception thrown in setValue", iae);
        }
        catch (IllegalAccessException iae2) {
            throw new RegistryException("Exception thrown in setValue", iae2);
        }
        catch (InvocationTargetException ite) {
            throw new RegistryException("Exception thrown in setValue", ite);
        }
    }

    public static void deleteValue(int hKey, String valueName) throws RegistryException {
        try {
            WindowsRegistry.initialize();
            byte[] barr = WindowsRegistry.stringToNullTerminated(valueName);
            int retval = (Integer)windowsRegDeleteValue.invoke((Object)systemRoot, hKey, barr);
            if (retval != 0) {
                throw new RegistryException(retval);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new RegistryException("Exception thrown in deleteValue", nsme);
        }
        catch (IllegalArgumentException iae) {
            throw new RegistryException("Exception thrown in deleteValue", iae);
        }
        catch (IllegalAccessException iae2) {
            throw new RegistryException("Exception thrown in deleteValue", iae2);
        }
        catch (InvocationTargetException ite) {
            throw new RegistryException("Exception thrown in deleteValue", ite);
        }
    }

    public static QueryInfoResult queryInfoKey(int hKey) throws RegistryException {
        int[] retval = null;
        try {
            WindowsRegistry.initialize();
            retval = (int[])windowsRegQueryInfoKey.invoke((Object)systemRoot, hKey);
        }
        catch (NoSuchMethodException nsme) {
            throw new RegistryException("Exception thrown in queryInfoKey", nsme);
        }
        catch (IllegalArgumentException iae) {
            throw new RegistryException("Exception thrown in queryInfoKey", iae);
        }
        catch (IllegalAccessException iae2) {
            throw new RegistryException("Exception thrown in queryInfoKey", iae2);
        }
        catch (InvocationTargetException ite) {
            throw new RegistryException("Exception thrown in queryInfoKey", ite);
        }
        return new QueryInfoResult(retval[0], retval[2], retval[3], retval[4]);
    }

    public static String enumKey(int hKey, int subKeyIndex, int maxKeyLength) throws RegistryException {
        byte[] retval = null;
        try {
            WindowsRegistry.initialize();
            retval = (byte[])windowsRegEnumKeyEx.invoke((Object)systemRoot, hKey, subKeyIndex, maxKeyLength);
        }
        catch (NoSuchMethodException nsme) {
            throw new RegistryException("Exception thrown in enumKey", nsme);
        }
        catch (IllegalArgumentException iae) {
            throw new RegistryException("Exception thrown in enumKey", iae);
        }
        catch (IllegalAccessException iae2) {
            throw new RegistryException("Exception thrown in enumKey", iae2);
        }
        catch (InvocationTargetException ite) {
            throw new RegistryException("Exception thrown in enumKey", ite);
        }
        return WindowsRegistry.nullTerminatedToString(retval);
    }

    public static String enumValue(int hKey, int valueIndex, int maxValueNameLength) throws RegistryException {
        byte[] retval = null;
        try {
            WindowsRegistry.initialize();
            retval = (byte[])windowsRegEnumValue.invoke((Object)systemRoot, hKey, valueIndex, maxValueNameLength);
        }
        catch (NoSuchMethodException nsme) {
            throw new RegistryException("Exception thrown in enumValue", nsme);
        }
        catch (IllegalArgumentException iae) {
            throw new RegistryException("Exception thrown in enumValue", iae);
        }
        catch (IllegalAccessException iae2) {
            throw new RegistryException("Exception thrown in enumValue", iae2);
        }
        catch (InvocationTargetException ite) {
            throw new RegistryException("Exception thrown in enumValue", ite);
        }
        return WindowsRegistry.nullTerminatedToString(retval);
    }

    public static void setKey(int hKey, String subKey, String name, String value) throws RegistryException {
        int handle = WindowsRegistry.createKey((int)hKey, (String)subKey).handle;
        handle = WindowsRegistry.openKey(hKey, subKey, 983103);
        WindowsRegistry.setValue(handle, name, value);
        WindowsRegistry.flushKey(handle);
        WindowsRegistry.closeKey(handle);
    }

    public static String getKey(int hKey, String subKey, String name) throws RegistryException {
        int handle = WindowsRegistry.openKey(hKey, subKey, 1);
        String s = WindowsRegistry.queryValue(handle, name);
        WindowsRegistry.closeKey(handle);
        return s;
    }

    public static String toString(int hKey, String subKey) throws RegistryException {
        StringBuilder sb = new StringBuilder();
        WindowsRegistry.toStringHelper(hKey, subKey, "", sb);
        return sb.toString();
    }

    private static void toStringHelper(int hKey, String subKey, String prefix, StringBuilder sb) throws RegistryException {
        String s;
        int i;
        int handle = WindowsRegistry.openKey(hKey, subKey, 9);
        QueryInfoResult qi = WindowsRegistry.queryInfoKey(handle);
        sb.append(prefix).append(subKey).append('\n');
        sb.append(prefix).append(qi.subkeyCount).append(" subkeys, ").append(qi.valueCount).append(" values\n");
        for (i = 0; i < qi.valueCount; ++i) {
            s = WindowsRegistry.enumValue(handle, i, qi.maxValueLength + 1);
            sb.append(prefix).append(s).append(" = ");
            s = WindowsRegistry.queryValue(handle, s);
            sb.append(s).append('\n');
        }
        for (i = 0; i < qi.subkeyCount; ++i) {
            s = WindowsRegistry.enumKey(handle, i, qi.maxSubkeyLength + 1);
            WindowsRegistry.toStringHelper(handle, s, prefix + "   ", sb);
        }
        WindowsRegistry.closeKey(handle);
    }

    public static void delKey(int hKey, String subKey) throws RegistryException {
        String s;
        int i;
        int handle = WindowsRegistry.openKey(hKey, subKey, 983103);
        QueryInfoResult qi = WindowsRegistry.queryInfoKey(handle);
        for (i = 0; i < qi.valueCount; ++i) {
            s = WindowsRegistry.enumValue(handle, i, qi.maxValueLength + 1);
            if (s == null) continue;
            WindowsRegistry.deleteValue(handle, s);
        }
        for (i = 0; i < qi.subkeyCount; ++i) {
            s = WindowsRegistry.enumKey(handle, i, qi.maxSubkeyLength + 1);
            if (s == null) continue;
            WindowsRegistry.delKey(handle, s);
        }
        WindowsRegistry.flushKey(handle);
        WindowsRegistry.closeKey(handle);
        WindowsRegistry.deleteKey(hKey, subKey);
    }

    public static byte[] stringToNullTerminated(String str) {
        return WindowsRegistry.stringToNullTerminated(str, Charset.defaultCharset());
    }

    public static byte[] stringToNullTerminated(String str, Charset charset) {
        return WindowsRegistry.stringToNullTerminated(str, charset.toString());
    }

    public static byte[] stringToNullTerminated(String str, String charset) {
        try {
            byte[] barr = str.getBytes(charset);
            byte[] result = new byte[barr.length + 1];
            System.arraycopy(barr, 0, result, 0, barr.length);
            result[result.length - 1] = 0;
            return result;
        }
        catch (UnsupportedEncodingException uee) {
            return new byte[]{0};
        }
    }

    public static String nullTerminatedToString(byte[] barr) {
        return WindowsRegistry.nullTerminatedToString(barr, Charset.defaultCharset());
    }

    public static String nullTerminatedToString(byte[] barr, Charset charset) {
        return WindowsRegistry.nullTerminatedToString(barr, charset.toString());
    }

    public static String nullTerminatedToString(byte[] barr, String charset) {
        try {
            if (barr == null) {
                return null;
            }
            int len = barr.length;
            if (barr[len - 1] == 0) {
                --len;
            }
            return new String(barr, 0, len, charset);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String hiveToString(int hive) {
        return hive == Integer.MIN_VALUE ? "HKEY_CLASSES_ROOT" : (hive == -2147483647 ? "HKEY_CURRENT_USER" : (hive == -2147483646 ? "HKEY_LOCAL_MACHINE" : "0x" + Integer.toHexString(hive)));
    }

    public static class QueryInfoResult {
        public int subkeyCount;
        public int valueCount;
        public int maxSubkeyLength;
        public int maxValueLength;

        public QueryInfoResult(int sc, int vc, int msl, int mvl) {
            this.subkeyCount = sc;
            this.valueCount = vc;
            this.maxSubkeyLength = msl;
            this.maxValueLength = mvl;
        }
    }

    public static class CreateResult {
        public int handle;
        public boolean wasCreated;

        public CreateResult(int h, boolean c) {
            this.handle = h;
            boolean wasCreated = c;
        }
    }

    public static class RegistryAccessDeniedException
    extends RegistryException {
        private int hive;
        private String subKey;

        public RegistryAccessDeniedException(int hive, String subKey) {
            super("Registry key " + WindowsRegistry.hiveToString(hive) + "\\" + subKey + " could not be accessed", 5);
            this.hive = hive;
            this.subKey = subKey;
        }

        public int getHive() {
            return this.hive;
        }

        public String getSubKey() {
            return this.subKey;
        }
    }

    public static class RegistryKeyNotFoundException
    extends RegistryException {
        private int hive;
        private String subKey;

        public RegistryKeyNotFoundException(int hive, String subKey) {
            super("Registry key " + WindowsRegistry.hiveToString(hive) + "\\" + subKey + " not found", 2);
            this.hive = hive;
            this.subKey = subKey;
        }

        public int getHive() {
            return this.hive;
        }

        public String getSubKey() {
            return this.subKey;
        }
    }

    public static class RegistryException
    extends Exception {
        private int errorCode = -1;

        public RegistryException(String s) {
            super(s);
        }

        public RegistryException(String s, Throwable cause) {
            super(s, cause);
        }

        public RegistryException(int error) {
            super("Error code " + error);
            this.errorCode = error;
        }

        public RegistryException(String s, int error) {
            super(s);
            this.errorCode = error;
        }

        public int getErrorCode() {
            return this.errorCode;
        }
    }
}

