/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.junit;

import edu.rice.cs.drjava.model.junit.JUnitModelCallback;
import edu.rice.cs.util.UnexpectedException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.BaseTestRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitTestRunner
extends BaseTestRunner {
    private JUnitModelCallback _jmc;
    private ClassLoader _loader;
    private TestResult _result;
    private int _errorCount;
    private int _failureCount;

    public JUnitTestRunner(JUnitModelCallback jmc, ClassLoader loader) {
        this._jmc = jmc;
        this._loader = loader;
        this._result = null;
        this._errorCount = 0;
        this._failureCount = 0;
    }

    public synchronized TestResult runSuite(TestSuite suite) {
        this._errorCount = 0;
        this._failureCount = 0;
        this._result = new TestResult();
        this._result.addListener(this);
        this._jmc.testSuiteStarted(suite.countTestCases());
        suite.run(this._result);
        return this._result;
    }

    public Class<?> loadPossibleTest(String className) throws ClassNotFoundException {
        return this._loader.loadClass(className);
    }

    protected Class<? extends TestCase> loadSuiteClass(String className) throws ClassNotFoundException {
        return this.loadPossibleTest(className).asSubclass(TestCase.class);
    }

    @Override
    public synchronized void testStarted(String testName) {
        this._jmc.testStarted(testName);
    }

    @Override
    public synchronized void testEnded(String testName) {
        boolean error = false;
        boolean failure = false;
        if (this._result.errorCount() > this._errorCount) {
            error = true;
            ++this._errorCount;
        }
        if (this._result.failureCount() > this._failureCount) {
            failure = true;
            ++this._failureCount;
        }
        boolean success = !failure && !error;
        this._jmc.testEnded(testName, success, failure);
    }

    @Override
    public synchronized void testFailed(int status, Test test, Throwable t) {
    }

    @Override
    protected void runFailed(String message) {
        throw new UnexpectedException(message);
    }
}

