/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.indent;

import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.definitions.indent.IndentRule;
import edu.rice.cs.drjava.model.definitions.indent.IndentRuleQuestion;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.definitions.reducedmodel.BraceInfo;
import edu.rice.cs.util.UnexpectedException;
import javax.swing.text.BadLocationException;

public class QuestionStartAfterOpenBrace
extends IndentRuleQuestion {
    public QuestionStartAfterOpenBrace(IndentRule yesRule, IndentRule noRule) {
        super(yesRule, noRule);
    }

    boolean applyRule(AbstractDJDocument doc, Indenter.IndentReason reason) {
        int origin = doc.getCurrentLocation();
        int lineStart = doc._getLineStartPos(origin);
        if (lineStart <= 1) {
            return false;
        }
        doc.setCurrentLocation(lineStart);
        BraceInfo info = doc._getLineEnclosingBrace();
        doc.setCurrentLocation(origin);
        if (!info.braceType().equals("{") || info.distance() <= 0) {
            return false;
        }
        int bracePos = lineStart - info.distance();
        int braceEndLinePos = doc._getLineEndPos(bracePos);
        int nextNonWS = -1;
        try {
            nextNonWS = doc.getFirstNonWSCharPos(braceEndLinePos);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        if (nextNonWS == -1) {
            return true;
        }
        return nextNonWS >= lineStart;
    }
}

