/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.model.DrJavaFileUtils;
import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageLevelStackTraceMapper {
    public static final Log LOG = new Log("llstm.txt", false);
    private HashMap<String, TreeMap<Integer, Integer>> cache;
    private GlobalModel aGModel;

    public LanguageLevelStackTraceMapper(GlobalModel aGM) {
        this.aGModel = aGM;
        this.cache = new HashMap();
    }

    public StackTraceElement replaceStackTraceElement(StackTraceElement s, File d, TreeMap<Integer, Integer> m) {
        if (!this.matches(d, s)) {
            return s;
        }
        StackTraceElement NewS = new StackTraceElement(s.getClassName(), s.getMethodName(), d.getName(), m.get(s.getLineNumber()));
        return NewS;
    }

    public StackTraceElement replaceStackTraceElement(StackTraceElement s, File d) {
        if (!this.matches(d, s)) {
            return s;
        }
        String fileName = d.getAbsolutePath();
        if (this.cache.containsKey(fileName)) {
            return this.replaceStackTraceElement(s, d, this.cache.get(fileName));
        }
        String dn = d.getName();
        dn = dn.substring(0, dn.lastIndexOf(46)) + ".java";
        File javaFile = new File(d.getParentFile(), dn);
        this.cache.put(fileName, this.readLLLineBlock(javaFile));
        return this.replaceStackTraceElement(s, d, this.cache.get(fileName));
    }

    public StackTraceElement replaceStackTraceElement(StackTraceElement s, List<File> ds) {
        for (int i = 0; i < ds.size(); ++i) {
            s = this.replaceStackTraceElement(s, ds.get(i));
        }
        return s;
    }

    public StackTraceElement[] replaceStackTrace(StackTraceElement[] ss, List<File> ds) {
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = this.replaceStackTraceElement(ss[i], ds);
        }
        return ss;
    }

    public void clearCache() {
        this.cache = new HashMap();
    }

    private boolean matches(File f, StackTraceElement s) {
        OpenDefinitionsDocument d;
        LOG.log("matches(" + f + ", " + s + ")");
        if (s.getFileName() == null) {
            return false;
        }
        try {
            d = this.aGModel.getDocumentForFile(f);
        }
        catch (IOException e) {
            return false;
        }
        String dn = d.getRawFile().getName();
        if (!DrJavaFileUtils.isLLFile(dn)) {
            return false;
        }
        dn = DrJavaFileUtils.getJavaForLLFile(dn);
        String dp = d.getPackageName();
        int dotPos = s.getClassName().lastIndexOf(46);
        if (dp.length() == 0 && dotPos >= 0) {
            return false;
        }
        if (dp.length() > 0 && dotPos < 0) {
            return false;
        }
        String sp = "";
        if (dotPos >= 0) {
            sp = s.getClassName().substring(0, dotPos);
        }
        if (!dp.equals(sp)) {
            return false;
        }
        return s.getFileName().equals(dn);
    }

    private TreeMap<Integer, Integer> createOneToOneMap(BufferedReader bufReader) {
        TreeMap<Integer, Integer> oneToOne = new TreeMap<Integer, Integer>();
        int lineNo = 1;
        oneToOne.put(lineNo, lineNo);
        try {
            String rdLine;
            while ((rdLine = bufReader.readLine()) != null) {
                oneToOne.put(++lineNo, lineNo);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return oneToOne;
    }

    public TreeMap<Integer, Integer> readLLLineBlock(File LLFile) {
        BufferedReader bufReader = null;
        String rdLine = "";
        try {
            bufReader = new BufferedReader(new FileReader(LLFile));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        try {
            rdLine = bufReader.readLine();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!rdLine.startsWith("// Language Level Converter line number map: dj*->java. Entries:")) {
            return this.createOneToOneMap(bufReader);
        }
        LOG.log("rdLine = '" + rdLine + "'");
        LOG.log("\tlastIndex = " + rdLine.lastIndexOf(" "));
        Integer mapSize = new Integer(rdLine.substring(rdLine.lastIndexOf(" ") + 1));
        try {
            rdLine = bufReader.readLine();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (rdLine.indexOf("//") != 0) {
            mapSize = 0;
        }
        String temp = "";
        String numRnum = "";
        TreeMap<Integer, Integer> javaDJMap = new TreeMap<Integer, Integer>();
        temp = rdLine.substring(2).trim() + " ";
        for (int i = 0; i < mapSize; ++i) {
            if (temp.length() < 2) {
                temp = this.readLLLineBlockHelper(bufReader);
            }
            if (temp == null) break;
            numRnum = temp.substring(0, temp.indexOf(" "));
            Integer djNum = new Integer(numRnum.substring(0, numRnum.indexOf("->")));
            Integer javaNum = new Integer(numRnum.substring(numRnum.indexOf("->") + 2));
            javaDJMap.put(javaNum, djNum);
            temp = temp.substring(temp.indexOf(" ")).trim() + " ";
        }
        return javaDJMap;
    }

    public TreeMap<Integer, Integer> ReadLanguageLevelLineBlockRev(File LLFile) {
        BufferedReader bufReader = null;
        String rdLine = "";
        try {
            bufReader = new BufferedReader(new FileReader(LLFile));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        try {
            rdLine = bufReader.readLine();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!rdLine.startsWith("// Language Level Converter line number map: dj*->java. Entries:")) {
            return this.createOneToOneMap(bufReader);
        }
        LOG.log("rdLine = '" + rdLine + "'");
        LOG.log("\tlastIndex = " + rdLine.lastIndexOf(" "));
        Integer mapSize = new Integer(rdLine.substring(rdLine.lastIndexOf(" ") + 1));
        try {
            rdLine = bufReader.readLine();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (rdLine.indexOf("//") != 0) {
            mapSize = 0;
        }
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        String temp = rdLine.substring(2).trim() + " ";
        String numRnum = "";
        for (int i = 0; i < mapSize; ++i) {
            if (temp.length() < 2) {
                temp = this.readLLLineBlockHelper(bufReader);
            }
            if (temp == null) break;
            numRnum = temp.substring(0, temp.indexOf(" "));
            int djNum = Integer.parseInt(numRnum.substring(0, numRnum.indexOf("->")), 10);
            int javaNum = Integer.parseInt(numRnum.substring(numRnum.indexOf("->") + 2), 10);
            map.put(djNum, javaNum);
            temp = temp.substring(temp.indexOf(" ")).trim() + " ";
        }
        return map;
    }

    private String readLLLineBlockHelper(BufferedReader br) {
        String line = "";
        try {
            line = br.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (line.indexOf("//") != 0) {
            return null;
        }
        line = line.substring(2).trim() + " ";
        return line;
    }
}

