/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.model.DummyGlobalModel;
import edu.rice.cs.drjava.model.DummyOpenDefDoc;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.GlobalEventNotifier;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.definitions.DefinitionsDocument;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.UnexpectedException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.text.BadLocationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDocGetter
extends DummyGlobalModel {
    HashMap<File, OpenDefinitionsDocument> docs;

    public TestDocGetter() {
        this(new File[0], new String[0]);
    }

    public TestDocGetter(File[] files, String[] texts) {
        if (files.length != texts.length) {
            throw new IllegalArgumentException("Argument arrays must match in size.");
        }
        this.docs = new HashMap(texts.length * 2);
        GlobalEventNotifier en = new GlobalEventNotifier();
        for (int i = 0; i < texts.length; ++i) {
            DefinitionsDocument doc = new DefinitionsDocument(en);
            TestOpenDoc odoc = new TestOpenDoc(doc);
            odoc.setFile(files[i]);
            try {
                doc.insertString(0, texts[i], null);
            }
            catch (BadLocationException e) {
                throw new UnexpectedException(e);
            }
            this.docs.put(files[i], odoc);
        }
    }

    @Override
    public OpenDefinitionsDocument getDocumentForFile(File file) throws IOException {
        if (this.docs.containsKey(file)) {
            return this.docs.get(file);
        }
        throw new IllegalStateException("TestDocGetter can't open new files!");
    }

    @Override
    public List<OpenDefinitionsDocument> getOpenDefinitionsDocuments() {
        return new ArrayList<OpenDefinitionsDocument>(this.docs.values());
    }

    private static class TestOpenDoc
    extends DummyOpenDefDoc {
        DefinitionsDocument _doc;
        File _file;

        TestOpenDoc(DefinitionsDocument d) {
            this._doc = d;
            this._defDoc = d;
            this._file = FileOps.NULL_FILE;
        }

        public DefinitionsDocument getDocument() {
            return this._doc;
        }

        public File getFile() throws FileMovedException {
            return this._file;
        }

        public void setFile(File f) {
            this._file = f;
        }
    }
}

