/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.AbstractGlobalModel;
import edu.rice.cs.drjava.model.LightWeightParsingControl;
import edu.rice.cs.drjava.model.LightWeightParsingListener;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.swing.Utilities;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.BadLocationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultLightWeightParsingControl
implements LightWeightParsingControl {
    private AbstractGlobalModel _model;
    private long _beginUpdates;
    private long _lastDelay = System.currentTimeMillis();
    private HashMap<OpenDefinitionsDocument, Long> _lastUpdates = new HashMap();
    private HashMap<OpenDefinitionsDocument, String> _enclosingClassNames = new HashMap();
    private volatile boolean _running = false;
    private Object _restart = new Object();
    private LinkedList<LightWeightParsingListener> _listeners = new LinkedList();
    private static final Log _log = new Log("LightWeightParsing", false);
    private ThreadGroup _updaterThreadGroup = new ThreadGroup("Light-weight parsing updater thread group"){

        public void uncaughtException(Thread t, Throwable e) {
            _log.log("Uncaught exception in updater; disabled for rest of session", e);
            DrJavaErrorHandler.record(e);
        }
    };
    private Thread _updater = new Thread(this._updaterThreadGroup, new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                if (!DefaultLightWeightParsingControl.this._running) {
                    _log.log("Waiting...");
                    try {
                        Object object = DefaultLightWeightParsingControl.this._restart;
                        synchronized (object) {
                            if (!DefaultLightWeightParsingControl.this._running) {
                                DefaultLightWeightParsingControl.this._restart.wait();
                            }
                        }
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                long current = System.currentTimeMillis();
                long delta = DefaultLightWeightParsingControl.this._beginUpdates - current;
                if (current >= DefaultLightWeightParsingControl.this._beginUpdates) {
                    OpenDefinitionsDocument doc = DefaultLightWeightParsingControl.this._model.getActiveDocument();
                    Long last = (Long)DefaultLightWeightParsingControl.this._lastUpdates.get(doc);
                    if (last == null || last < DefaultLightWeightParsingControl.this._lastDelay) {
                        DefaultLightWeightParsingControl.this.update(doc);
                    }
                    delta = DrJava.getConfig().getSetting(OptionConstants.DIALOG_LIGHTWEIGHT_PARSING_DELAY).intValue();
                }
                try {
                    Thread.sleep(delta);
                }
                catch (InterruptedException e) {
                }
            }
        }
    });

    public DefaultLightWeightParsingControl(AbstractGlobalModel model) {
        this._model = model;
        this._updater.setDaemon(true);
        this._updater.start();
    }

    @Override
    public synchronized void update(final OpenDefinitionsDocument doc) {
        _log.log("Update for " + doc);
        try {
            this._lastUpdates.put(doc, System.currentTimeMillis());
            final String old = this._enclosingClassNames.get(doc);
            final String updated = doc.getEnclosingClassName(doc.getCurrentLocation(), true);
            if (old == null || !old.equals(updated)) {
                this._enclosingClassNames.put(doc, updated);
                Utilities.invokeLater(new Runnable(){

                    public void run() {
                        List<LightWeightParsingListener> listeners = DefaultLightWeightParsingControl.this.getListeners();
                        for (LightWeightParsingListener l : listeners) {
                            l.enclosingClassNameUpdated(doc, old, updated);
                        }
                    }
                });
            }
        }
        catch (BadLocationException e) {
        }
        catch (ClassNameNotFoundException classNameNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutomaticUpdates(boolean b) {
        _log.log("setAutomaticUpdates(" + b + ")");
        this._running = b;
        if (b) {
            this.delay();
            Object object = this._restart;
            synchronized (object) {
                this._restart.notify();
            }
        }
    }

    @Override
    public void delay() {
        this._lastDelay = System.currentTimeMillis();
        this._beginUpdates = this._lastDelay + (long)DrJava.getConfig().getSetting(OptionConstants.DIALOG_LIGHTWEIGHT_PARSING_DELAY).intValue();
    }

    @Override
    public synchronized void reset() {
        for (final OpenDefinitionsDocument doc : this._enclosingClassNames.keySet()) {
            final String old = this._enclosingClassNames.get(doc);
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    List<LightWeightParsingListener> listeners = DefaultLightWeightParsingControl.this.getListeners();
                    for (LightWeightParsingListener l : listeners) {
                        l.enclosingClassNameUpdated(doc, old, null);
                    }
                }
            });
        }
        this._enclosingClassNames.clear();
        this._lastUpdates.clear();
    }

    @Override
    public synchronized String getEnclosingClassName(OpenDefinitionsDocument doc) {
        return this._enclosingClassNames.get(doc);
    }

    @Override
    public synchronized void addListener(LightWeightParsingListener l) {
        this._listeners.add(l);
    }

    @Override
    public synchronized void removeListener(LightWeightParsingListener l) {
        this._listeners.remove(l);
    }

    @Override
    public synchronized void removeAllListeners() {
        this._listeners.clear();
    }

    @Override
    public synchronized List<LightWeightParsingListener> getListeners() {
        return new LinkedList<LightWeightParsingListener>(this._listeners);
    }
}

