/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.config.DrJavaProperty;
import edu.rice.cs.drjava.config.PropertyMaps;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.StringOps;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileProperty
extends DrJavaProperty {
    protected Thunk<File> _getFile;

    public FileProperty(String name, Thunk<File> getFile, String help) {
        super(name, help);
        this._getFile = getFile;
        this.resetAttributes();
    }

    @Override
    public String getCurrent(PropertyMaps pm) {
        this.update(pm);
        if (this._value == null) {
            throw new IllegalArgumentException("DrJavaProperty value is null");
        }
        this._isCurrent = true;
        return this._value;
    }

    @Override
    public String toString() {
        return this._value;
    }

    @Override
    public boolean isCurrent() {
        return true;
    }

    @Override
    public void invalidate() {
        this.invalidateOthers(new HashSet<DrJavaProperty>());
    }

    @Override
    public void update(PropertyMaps pm) {
        block9: {
            String quot = "";
            String q = (String)this._attributes.get("squote");
            if (q != null && q.toLowerCase().equals("true")) {
                quot = "'";
            }
            if ((q = (String)this._attributes.get("dquote")) != null && q.toLowerCase().equals("true")) {
                quot = "\"" + quot;
            }
            try {
                File f;
                if (this._getFile == null || (f = this._getFile.value()) == null) {
                    this._value = "";
                    return;
                }
                if (((String)this._attributes.get("rel")).equals("/")) {
                    f = f.getAbsoluteFile();
                    try {
                        f = f.getCanonicalFile();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    this._value = StringOps.escapeFileName(f.toString());
                    break block9;
                }
                File rf = new File(StringOps.unescapeFileName(StringOps.replaceVariables((String)this._attributes.get("rel"), pm, PropertyMaps.GET_CURRENT)));
                String s = FileOps.stringMakeRelativeTo(f, rf);
                this._value = quot + StringOps.escapeFileName(s) + quot;
            }
            catch (IOException e) {
                this._value = "(Error...)";
            }
            catch (SecurityException e) {
                this._value = "(Error...)";
            }
        }
    }

    @Override
    public void resetAttributes() {
        this._attributes.clear();
        this._attributes.put("rel", "/");
        this._attributes.put("squote", null);
        this._attributes.put("dquote", null);
    }
}

