/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.record.graph;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockInfo {
    long _uniqueId;
    String _description;
    Long _owningThreadId;
    Set<Long> _waitingThreadIds;

    public LockInfo(Long uniqueId, String description, long owningThreadId, Set<Long> waitingThreadIds) {
        this._uniqueId = uniqueId;
        this._description = description;
        this._owningThreadId = owningThreadId;
        this._waitingThreadIds = new HashSet<Long>(waitingThreadIds);
    }

    public LockInfo(ObjectReference objRef) {
        this._uniqueId = objRef.uniqueID();
        this._description = objRef.type().toString();
        this._waitingThreadIds = new HashSet<Long>();
        try {
            ThreadReference threadRef = objRef.owningThread();
            this._owningThreadId = threadRef != null ? Long.valueOf(threadRef.uniqueID()) : null;
            for (ThreadReference tr : objRef.waitingThreads()) {
                this._waitingThreadIds.add(tr.uniqueID());
            }
        }
        catch (IncompatibleThreadStateException e) {
            throw new RuntimeException(e);
        }
    }

    public long getUniqueId() {
        return this._uniqueId;
    }

    public Long getOwningThreadId() {
        return this._owningThreadId;
    }

    public void setOwningThreadId(Long owningThreadId) {
        this._owningThreadId = owningThreadId;
    }

    public Set<Long> getWaitingThreadIds() {
        return this._waitingThreadIds;
    }

    public String getDescription() {
        return this._description;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._description);
        sb.append(" (id=");
        sb.append(this._uniqueId);
        if (this._owningThreadId != null) {
            sb.append("), owned by thread id=");
            sb.append(this._owningThreadId);
        } else {
            sb.append("), not owned");
        }
        if (this._waitingThreadIds.size() == 0) {
            sb.append(", not contended");
        } else {
            sb.append(", contended by thread ids=");
            boolean first = true;
            for (Long id : this._waitingThreadIds) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(id);
            }
        }
        return sb.toString();
    }
}

