/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors;

import edu.rice.cs.cunit.instrumentors.RetryIOException;
import java.io.File;
import java.io.IOException;

public class CouldNotDoubleRenameException
extends RetryIOException {
    private File _curFile = null;
    private File _oldFile = null;
    private File _newFile = null;

    public CouldNotDoubleRenameException(File curFile, File oldFile, File newFile) {
        super("Could not rename file " + curFile.getPath() + " to " + oldFile.getPath() + " and rename file " + newFile.getPath() + " to " + curFile.getPath());
        this._curFile = curFile;
        this._oldFile = oldFile;
        this._newFile = newFile;
    }

    public void retry() throws IOException {
        if (this._curFile.exists() && !this._oldFile.exists() && this._newFile.exists()) {
            boolean res = this._curFile.renameTo(this._oldFile);
            if (!res) {
                throw new IOException(this.getMessage());
            }
            res = this._newFile.renameTo(this._curFile);
            if (!res) {
                throw new IOException(this.getMessage());
            }
        } else {
            throw new IOException(this.getMessage() + "; cannot fix, situation not applicable");
        }
    }
}

