/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors;

import edu.rice.cs.cunit.instrumentors.RetryIOException;
import java.io.File;
import java.io.IOException;

public class CouldNotDeleteAndRenameException
extends RetryIOException {
    private File _toDelete = null;
    private File _toRename = null;

    public CouldNotDeleteAndRenameException(File toDelete, File toRename) {
        super("Could not delete file " + toDelete.getPath() + " or rename file " + toRename.getPath());
        this._toDelete = toDelete;
        this._toRename = toRename;
    }

    public void retry() throws IOException {
        if (this._toDelete.exists() && this._toRename.exists()) {
            if (this._toDelete.exists() && !this._toDelete.delete()) {
                throw new IOException(this.getMessage());
            }
            if (this._toRename.exists() && !this._toRename.renameTo(this._toDelete)) {
                throw new IOException(this.getMessage());
            }
        } else {
            throw new IOException(this.getMessage() + "; cannot fix, situation not applicable");
        }
    }
}

