/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.constantPool;

import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.IPoolInfoVisitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringPoolInfo
extends APoolInfo {
    private AUTFPoolInfo _utf;
    private short _utfIndex;

    public StringPoolInfo(AUTFPoolInfo utf, ConstantPool cp) {
        super(8, cp);
        this._utf = utf;
        this.reindex();
    }

    public StringPoolInfo(DataInputStream dis, ConstantPool cp) throws IOException {
        super(8, cp);
        this._utfIndex = dis.readShort();
    }

    public AUTFPoolInfo getUtf() {
        return this._utf;
    }

    public void setUtf(AUTFPoolInfo utf) {
        this._utf = utf;
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        this.reindex();
        dos.writeByte(this._type);
        dos.writeShort(this._utfIndex);
    }

    @Override
    public void resolve() {
        this._utf = ((APoolInfo)this._constantPool.get(this._utfIndex)).execute(CheckUTFVisitor.singleton(), null);
    }

    @Override
    public void reindex() {
        this._utfIndex = this._constantPool.indexOf(this._utf);
    }

    @Override
    public String toStringVerbose() {
        StringBuilder s = new StringBuilder();
        s.append("CONSTANT_String: Name = #");
        s.append(this._utfIndex);
        s.append(' ');
        s.append(this.toString());
        return s.toString();
    }

    @Override
    public String toString() {
        return this._utf.toString();
    }

    @Override
    public int hashCode() {
        return this._utfIndex;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof StringPoolInfo && (((StringPoolInfo)obj)._utfIndex == this._utfIndex || ((StringPoolInfo)obj)._utf == this._utf);
    }

    @Override
    public <R, D> R execute(IPoolInfoVisitor<R, D> visitor, D data) {
        return visitor.stringCase(this, data);
    }
}

