/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.constantPool;

import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.IPoolInfoVisitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPoolInfo
extends APoolInfo {
    private AUTFPoolInfo _name;
    private short _nameIndex;

    public ClassPoolInfo(AUTFPoolInfo name, ConstantPool cp) {
        super(7, cp);
        this._name = name;
        this.reindex();
    }

    public ClassPoolInfo(DataInputStream dis, ConstantPool cp) throws IOException {
        super(7, cp);
        this._nameIndex = dis.readShort();
    }

    public AUTFPoolInfo getName() {
        return this._name;
    }

    public void setName(AUTFPoolInfo name) {
        this._name = name;
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        this.reindex();
        dos.writeByte(this._type);
        dos.writeShort(this._nameIndex);
    }

    @Override
    public void resolve() {
        this._name = ((APoolInfo)this._constantPool.get(this._nameIndex)).execute(CheckUTFVisitor.singleton(), null);
    }

    @Override
    public void reindex() {
        this._nameIndex = this._constantPool.indexOf(this._name);
    }

    @Override
    public String toStringVerbose() {
        StringBuilder s = new StringBuilder();
        s.append("CONSTANT_Class: Name = #");
        s.append(this._nameIndex);
        s.append(' ');
        s.append(this.toString());
        return s.toString();
    }

    @Override
    public String toString() {
        return this._name.toString();
    }

    @Override
    public int hashCode() {
        return this._nameIndex;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ClassPoolInfo && (((ClassPoolInfo)obj)._nameIndex == this._nameIndex || ((ClassPoolInfo)obj)._name == this._name);
    }

    @Override
    public <R, D> R execute(IPoolInfoVisitor<R, D> visitor, D data) {
        return visitor.classCase(this, data);
    }
}

