/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.code.instructions;

import edu.rice.cs.cunit.classFile.code.InstructionList;
import edu.rice.cs.cunit.classFile.code.Opcode;
import edu.rice.cs.cunit.classFile.code.instructions.AInstruction;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineNumberTable {
    Hashtable<Integer, Integer> _pcToLineNumber = new Hashtable();
    Hashtable<Integer, Integer> _lineNumberToPC = new Hashtable();
    int _maxPC;
    int _maxLineNo;

    protected void put(int pc, int lineNo) {
        this._pcToLineNumber.put(pc, lineNo);
        this._lineNumberToPC.put(lineNo, pc);
    }

    public LineNumberTable(byte[] bytecode) {
        int pc = 0;
        int lineNo = 0;
        while (pc < bytecode.length) {
            this.put(pc, lineNo);
            pc += Opcode.getInstrSize(bytecode, pc);
            ++lineNo;
        }
        if (pc != bytecode.length) {
            throw new IllegalArgumentException("Invalid bytecode length");
        }
        this.put(bytecode.length, lineNo);
    }

    public LineNumberTable(LinkedList<AInstruction> instrList) {
        int pc = 0;
        int lineNo = 0;
        for (AInstruction i : instrList) {
            this.put(pc, lineNo);
            pc += i.getBytecodeLength(pc);
            ++lineNo;
        }
        this.put(pc, instrList.size());
    }

    public LineNumberTable(InstructionList ilist) {
        int pc = 0;
        if (ilist.getLength() > 0) {
            InstructionList copy = new InstructionList(ilist);
            copy.setIndex(0);
            int lineNo = 0;
            do {
                this.put(pc, lineNo);
                pc += copy.getInstr().getBytecodeLength(pc);
                ++lineNo;
            } while (copy.advanceIndex());
        }
        this.put(pc, ilist.getLength());
    }

    public int getLineNumber(int pc) throws NoSuchElementException {
        Integer i = this._pcToLineNumber.get(pc);
        if (i == null) {
            throw new NoSuchElementException("No line number found for PC=" + pc);
        }
        return i;
    }

    public int getPC(int lineNo) throws NoSuchElementException {
        Integer i = this._lineNumberToPC.get(lineNo);
        if (i == null) {
            throw new NoSuchElementException("No PC found for line no=" + lineNo);
        }
        return i;
    }
}

