/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.code;

import edu.rice.cs.cunit.classFile.attributes.CodeAttributeInfo;
import edu.rice.cs.cunit.classFile.code.Opcode;
import edu.rice.cs.cunit.classFile.code.instructions.AInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;

public class InstructionList {
    LinkedList<AInstruction> _instructionList = new LinkedList();
    protected int _index;
    LineNumberTable _lnt;

    public InstructionList(byte[] code) {
        this.setCode(code);
        this._index = 0;
    }

    public InstructionList(InstructionList original) {
        this._instructionList.addAll(original._instructionList);
        this._index = original._index;
        this._lnt = original._lnt;
    }

    public InstructionList(byte[] code, int index) throws IndexOutOfBoundsException {
        this(code);
        this.setIndex(index);
    }

    public String toString() {
        return this.toString(true, true, null);
    }

    public String toString(ConstantPool cp) {
        return this.toString(true, true, cp);
    }

    public String toString(boolean lineNumbers, boolean PCs, ConstantPool cp) {
        StringBuilder x = new StringBuilder();
        int index = 0;
        int pc = 0;
        for (AInstruction instr : this._instructionList) {
            if (lineNumbers) {
                x.append(String.format("%5d", new Integer(index)));
                if (PCs) {
                    x.append(' ');
                } else {
                    x.append(": ");
                }
            }
            if (PCs) {
                x.append(String.format("(pc %5d): ", new Integer(pc)));
            }
            if (!lineNumbers && !PCs) {
                x.append("        ");
            }
            if (cp != null) {
                x.append(instr.toStringVerbose(cp));
            } else {
                x.append(instr.toString());
            }
            x.append("\n");
            pc += instr.getBytecodeLength(pc);
            ++index;
        }
        return x.toString();
    }

    public byte[] getCode() throws IllegalStateException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int pc = 0;
        for (AInstruction instr : this._instructionList) {
            byte[] b = instr.getBytecode(pc, this._lnt);
            try {
                baos.write(b);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not generate bytecode", e);
            }
            pc += b.length;
        }
        return baos.toByteArray();
    }

    public void setCode(byte[] code) {
        int pc;
        this._lnt = new LineNumberTable(code);
        this._instructionList = new LinkedList();
        for (pc = 0; pc < code.length; pc += Opcode.getInstrSize(code, pc)) {
            this._instructionList.addLast(AInstruction.makeInstruction(code, pc, pc, this._lnt));
        }
        if (pc != code.length) {
            throw new IllegalArgumentException("Invalid bytecode length");
        }
        this._index = 0;
    }

    public int getIndex() {
        return this._index;
    }

    public int getPCFromIndex(int index) {
        int pc = 0;
        for (int i = 0; i < index; ++i) {
            pc += this._instructionList.get(i).getBytecodeLength(pc);
        }
        return pc;
    }

    public int getLength() {
        return this._instructionList.size();
    }

    public void setIndex(int index) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (index < 0 || index >= this._instructionList.size()) {
            throw new IndexOutOfBoundsException("The program index (" + index + ") is not within the instruction list (length=" + this._instructionList.size() + ")");
        }
        this._index = index;
    }

    public boolean advanceIndex(int count) {
        while (count > 0) {
            if (!this.advanceIndex()) {
                return false;
            }
            --count;
        }
        return true;
    }

    public boolean advanceIndex() {
        if (this._index < 0) {
            throw new IndexOutOfBoundsException("The program index (" + this._index + ") is not within the instruction list (length=" + this._instructionList.size() + ")");
        }
        if (this._index < this._instructionList.size()) {
            ++this._index;
        }
        return this._index < this._instructionList.size();
    }

    public boolean rewindIndex(int count) {
        while (count > 0) {
            if (!this.rewindIndex()) {
                return false;
            }
            --count;
        }
        return true;
    }

    public boolean rewindIndex() {
        if (this._index < 0) {
            throw new IndexOutOfBoundsException("The program index (" + this._index + ") is not within the instruction list (length=" + this._instructionList.size() + ")");
        }
        if (this._index > 0) {
            --this._index;
        }
        return this._index > 0;
    }

    public byte getOpcode() {
        if (this._index < 0 || this._index >= this._instructionList.size()) {
            throw new IndexOutOfBoundsException("The program index (" + this._index + ") is not within the instruction list (length=" + this._instructionList.size() + ")");
        }
        return this._instructionList.get(this._index).getOpcode();
    }

    public AInstruction getInstr() {
        if (this._index < 0 || this._index >= this._instructionList.size()) {
            throw new IndexOutOfBoundsException("The program index (" + this._index + ") is not within the instruction list (length=" + this._instructionList.size() + ")");
        }
        return this._instructionList.get(this._index);
    }

    public boolean deleteInstr(CodeAttributeInfo codeAttribute) {
        if (this._index < 0 || this._index >= this._instructionList.size()) {
            throw new IndexOutOfBoundsException("The program index (" + this._index + ") is not within the instruction list (length=" + this._instructionList.size() + ")");
        }
        byte[] oldCode = this.getCode();
        int deletionPoint = this._index;
        InstructionList oldCodeBlock = new InstructionList(oldCode);
        do {
            if (!Opcode.isBranch(oldCodeBlock.getOpcode())) continue;
            int[] branchTargets = oldCodeBlock.getInstr().getBranchTargets();
            for (int i = 0; i < branchTargets.length; ++i) {
                if (branchTargets[i] <= deletionPoint && branchTargets[i] != oldCodeBlock.getLength() - 1) continue;
                int n = i;
                branchTargets[n] = branchTargets[n] - 1;
            }
            oldCodeBlock.getInstr().setBranchTargets(branchTargets);
        } while (oldCodeBlock.advanceIndex());
        oldCodeBlock._instructionList.remove(deletionPoint);
        oldCodeBlock._lnt = new LineNumberTable(oldCodeBlock);
        byte[] newCode = oldCodeBlock.getCode();
        if (codeAttribute != null) {
            codeAttribute.translatePC(deletionPoint, -1, this._lnt, oldCodeBlock._lnt);
        }
        this.setCode(newCode);
        if (deletionPoint == this.getLength()) {
            this._index = this.getLength();
            return false;
        }
        this.setIndex(deletionPoint);
        return true;
    }

    public void insertInstr(AInstruction instr, CodeAttributeInfo codeAttribute) {
        byte[] oldCode = this.getCode();
        int insertionPoint = this._index;
        InstructionList oldCodeBlock = new InstructionList(oldCode);
        do {
            if (!Opcode.isBranch(oldCodeBlock.getOpcode())) continue;
            AInstruction relocInstr = oldCodeBlock.getInstr();
            int ip = insertionPoint;
            this.relocateBranches(relocInstr, ip);
        } while (oldCodeBlock.advanceIndex());
        if (Opcode.isBranch(instr.getOpcode())) {
            this.relocateBranches(instr, insertionPoint - 1);
        }
        oldCodeBlock._instructionList.add(insertionPoint, instr);
        oldCodeBlock._lnt = new LineNumberTable(oldCodeBlock);
        byte[] newCode = oldCodeBlock.getCode();
        if (codeAttribute != null) {
            codeAttribute.translatePC(insertionPoint, 1, this._lnt, oldCodeBlock._lnt);
        }
        this.setCode(newCode);
        this.setIndex(insertionPoint);
    }

    protected void relocateBranches(AInstruction relocInstr, int ip) {
        int[] branchTargets = relocInstr.getBranchTargets();
        for (int i = 0; i < branchTargets.length; ++i) {
            if (branchTargets[i] <= ip) continue;
            int n = i;
            branchTargets[n] = branchTargets[n] + 1;
        }
        relocInstr.setBranchTargets(branchTargets);
    }

    public void insertBeforeInstr(AInstruction instr, CodeAttributeInfo codeAttribute) {
        byte[] oldCode = this.getCode();
        int insertionPoint = this._index;
        InstructionList oldCodeBlock = new InstructionList(oldCode);
        do {
            if (!Opcode.isBranch(oldCodeBlock.getOpcode())) continue;
            AInstruction relocInstr = oldCodeBlock.getInstr();
            this.relocateBranches(relocInstr, insertionPoint - 1);
        } while (oldCodeBlock.advanceIndex());
        if (Opcode.isBranch(instr.getOpcode())) {
            this.relocateBranches(instr, insertionPoint - 1);
        }
        oldCodeBlock._instructionList.add(insertionPoint, instr);
        oldCodeBlock._lnt = new LineNumberTable(oldCodeBlock);
        byte[] newCode = oldCodeBlock.getCode();
        if (codeAttribute != null) {
            codeAttribute.translatePC(insertionPoint - 1, 1, this._lnt, oldCodeBlock._lnt);
        }
        this.setCode(newCode);
        this.setIndex(insertionPoint);
    }

    public boolean findOpcode(byte opcode) {
        return this.findOpcode(new byte[]{opcode});
    }

    public boolean findOpcode(byte[] opcodes) {
        if (this._index < 0) {
            throw new IndexOutOfBoundsException("The program index (" + this._index + ") is not within the instruction list (length=" + this._instructionList.size() + ")");
        }
        if (this._index == this._instructionList.size()) {
            return false;
        }
        ArrayList<Byte> opcodeList = new ArrayList<Byte>(opcodes.length);
        for (byte o : opcodes) {
            opcodeList.add(o);
        }
        do {
            if (!opcodeList.contains(this.getOpcode())) continue;
            return true;
        } while (this.advanceIndex());
        return false;
    }

    public boolean findInstruction(AInstruction instr) {
        return this.findInstruction(new AInstruction[]{instr});
    }

    public boolean findInstruction(AInstruction[] instrs) {
        if (this._index < 0) {
            throw new IndexOutOfBoundsException("The program index (" + this._index + ") is not within the instruction list (length=" + this._instructionList.size() + ")");
        }
        if (this._index == this._instructionList.size()) {
            return false;
        }
        ArrayList<AInstruction> instrList = new ArrayList<AInstruction>(instrs.length);
        for (AInstruction o : instrs) {
            instrList.add(o);
        }
        do {
            if (!instrList.contains(this.getInstr())) continue;
            return true;
        } while (this.advanceIndex());
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstructionList)) {
            return false;
        }
        InstructionList instructionList = (InstructionList)o;
        return this._instructionList.equals(instructionList._instructionList);
    }

    public int hashCode() {
        return this._instructionList.hashCode();
    }
}

