/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.attributes;

import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.visitors.IAttributeVisitor;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ASCIIPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import edu.rice.cs.cunit.instrumentors.IInstrumentationStrategy;
import java.io.ByteArrayOutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationAttributeInfo
extends AAttributeInfo {
    public static final String NAME = "edu.rice.cs.cunit.Instrumentation";

    public InstrumentationAttributeInfo(AUTFPoolInfo name, byte[] data, ConstantPool cp) throws ClassFormatError {
        super(name, data, cp);
    }

    public String[] getInstrumentatorClassNames() throws ClassFormatError {
        String s = new String(this._data);
        return s.split(";");
    }

    public String getInstrumentatorClassNameString() throws ClassFormatError {
        return new String(this._data);
    }

    public void setInstrumentatorClassNames(String[] classNames) {
        StringBuilder sb = new StringBuilder();
        for (String s : classNames) {
            sb.append(';');
            sb.append(s);
        }
        String s = sb.toString();
        this._data = new byte[s.length() - 1];
        System.arraycopy(s.toCharArray(), 1, this._data, 0, s.length() - 1);
    }

    @Override
    public <R, D> R execute(IAttributeVisitor<R, D> visitor, D param) {
        return visitor.instrumentationCase(this, param);
    }

    @Override
    public void adjustPC(int startPC, int deltaPC) {
    }

    @Override
    public void translatePC(int index, int deltaIndex, LineNumberTable oldLnt, LineNumberTable newLnt) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String toString() {
        return "Instrumentors  = " + this.getInstrumentatorClassNameString();
    }

    public static void addInstrumentationAttributeInfo(ClassFile cf, String s) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (char ch : s.toCharArray()) {
            baos.write(ch);
        }
        AUTFPoolInfo attributeName = new ASCIIPoolInfo(NAME, cf.getConstantPool());
        int[] l = cf.addConstantPoolItems(new APoolInfo[]{attributeName});
        attributeName = cf.getConstantPoolItem(l[0]).execute(CheckUTFVisitor.singleton(), null);
        cf.addAttribute(new InstrumentationAttributeInfo(attributeName, baos.toByteArray(), cf.getConstantPool()));
    }

    public static void addInstrumentationAttributeInfo(ClassFile cf, List<IInstrumentationStrategy> itors) {
        StringBuilder sb = new StringBuilder();
        for (IInstrumentationStrategy itor : itors) {
            sb.append(';');
            sb.append(itor.getClass().getName());
        }
        String s = sb.toString();
        if (s.length() > 0) {
            s = s.substring(1);
        }
        InstrumentationAttributeInfo.addInstrumentationAttributeInfo(cf, s);
    }

    public static String getAttributeName() {
        return NAME;
    }
}

