/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile;

import edu.rice.cs.cunit.classFile.ClassFileTools;
import edu.rice.cs.cunit.classFile.FieldInfo;
import edu.rice.cs.cunit.classFile.MethodInfo;
import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.SourceFileAttributeInfo;
import edu.rice.cs.cunit.classFile.constantPool.AClassNameTypePoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ASCIIPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ClassPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.DoublePoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.EmptyPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.FieldPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.InterfaceMethodPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.LongPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.MethodPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.NameAndTypePoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.StringPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.UnicodePoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.visitors.ADefaultPoolInfoVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.AValueReferencePoolInfoVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckClassVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckLongVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckMethodVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckNameAndTypeVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.GetPoolInfoSizeVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.NoOpPoolInfoVisitor;
import edu.rice.cs.cunit.util.PositionDataInputStream;
import edu.rice.cs.cunit.util.PositionInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFile {
    private short _majorVersion;
    private short _minorVersion;
    private ConstantPool _constantPool = new ConstantPool();
    private short _classAccessFlags;
    private ClassPoolInfo _thisClass;
    private ClassPoolInfo _superClass;
    private ArrayList<ClassPoolInfo> _interfaces = new ArrayList();
    private ArrayList<FieldInfo> _fields = new ArrayList();
    private ArrayList<MethodInfo> _methods = new ArrayList();
    private ArrayList<AAttributeInfo> _attributes = new ArrayList();
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_VARARGS = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_ENUM = 16384;
    private static final int JAVA_FILE_MAGIC = -889275714;

    public ClassFile(short majorVersion, short minorVersion, short classAccessFlags, String thisClassName, String superClassName) {
        this._majorVersion = majorVersion;
        this._minorVersion = minorVersion;
        this._constantPool = new ConstantPool(1);
        this._constantPool.add(EmptyPoolInfo.singleton());
        for (APoolInfo cpi : this._constantPool) {
            cpi.resolve();
        }
        this._classAccessFlags = classAccessFlags;
        AUTFPoolInfo thisClassNameInfo = new ASCIIPoolInfo(thisClassName, this._constantPool);
        int[] l = this.addConstantPoolItems(new APoolInfo[]{thisClassNameInfo});
        thisClassNameInfo = this.getConstantPoolItem(l[0]).execute(CheckUTFVisitor.singleton(), null);
        this._thisClass = new ClassPoolInfo(thisClassNameInfo, this._constantPool);
        l = this.addConstantPoolItems(new APoolInfo[]{this._thisClass});
        this._thisClass = this.getConstantPoolItem(l[0]).execute(CheckClassVisitor.singleton(), null);
        if (!thisClassName.equals("java/lang/Object")) {
            AUTFPoolInfo superClassNameInfo = new ASCIIPoolInfo(superClassName, this._constantPool);
            l = this.addConstantPoolItems(new APoolInfo[]{superClassNameInfo});
            superClassNameInfo = this.getConstantPoolItem(l[0]).execute(CheckUTFVisitor.singleton(), null);
            this._superClass = new ClassPoolInfo(superClassNameInfo, this._constantPool);
            l = this.addConstantPoolItems(new APoolInfo[]{this._superClass});
            this._superClass = this.getConstantPoolItem(l[0]).execute(CheckClassVisitor.singleton(), null);
        }
        this._interfaces = new ArrayList(0);
        this._fields = new ArrayList(0);
        this._methods = new ArrayList(0);
        this._attributes = new ArrayList(0);
    }

    public ClassFile(InputStream in) throws IOException, ClassFormatError {
        PositionDataInputStream di = new PositionDataInputStream(new PositionInputStream(in));
        this.readHeader(di);
        this.readConstantPool(di);
        this.readClassInfo(di);
        this.readInterfaces(di);
        this.readFields(di);
        this.readMethods(di);
        this.readAttributes(di);
    }

    public ClassFile(byte[] b) throws IOException, ClassFormatError {
        this(new ByteArrayInputStream(b));
    }

    protected void readHeader(PositionDataInputStream di) throws IOException, ClassFormatError {
        int magic = di.readInt();
        if (-889275714 != magic) {
            throw new ClassFormatError("Wrong _magic");
        }
        this._minorVersion = di.readShort();
        this._majorVersion = di.readShort();
    }

    protected void readConstantPool(PositionDataInputStream di) throws IOException, ClassFormatError {
        APoolInfo cpi;
        int count = di.readShort();
        this._constantPool = new ConstantPool(count);
        for (int i = 0; i < count; ++i) {
            this._constantPool.add(EmptyPoolInfo.singleton());
        }
        for (int index = 1; index < this._constantPool.size(); index += cpi.execute(GetPoolInfoSizeVisitor.singleton(), null).intValue()) {
            cpi = APoolInfo.read(di, this._constantPool);
            this._constantPool.set(index, cpi);
        }
        for (APoolInfo cpi2 : this._constantPool) {
            cpi2.resolve();
        }
    }

    protected void readClassInfo(PositionDataInputStream di) throws IOException, ClassFormatError {
        this._classAccessFlags = di.readShort();
        this._thisClass = ((APoolInfo)this._constantPool.get(di.readShort())).execute(CheckClassVisitor.singleton(), null);
        short superClassIndex = di.readShort();
        if ("java/lang/Object".equals(this._thisClass.getName().toString())) {
            if (0 != superClassIndex) {
                throw new ClassFormatError("java.lang.Object must have 0 as superclass index");
            }
        } else {
            this._superClass = ((APoolInfo)this._constantPool.get(superClassIndex)).execute(CheckClassVisitor.singleton(), null);
        }
    }

    protected void readInterfaces(PositionDataInputStream di) throws IOException, ClassFormatError {
        int count = di.readShort();
        if (0 != count) {
            int i;
            this._interfaces = new ArrayList(count);
            for (i = 0; i < count; ++i) {
                this._interfaces.add(null);
            }
            for (i = 0; i < count; ++i) {
                short iindex = di.readShort();
                if (1 > iindex || iindex > this._constantPool.size() - 1) {
                    throw new ClassFormatError("Interface number out of range, index=" + i);
                }
                this._interfaces.set(i, ((APoolInfo)this._constantPool.get(iindex)).execute(CheckClassVisitor.singleton(), null));
            }
        }
    }

    protected void readFields(PositionDataInputStream di) throws IOException, ClassFormatError {
        int count = di.readShort();
        if (0 != count) {
            int i;
            this._fields = new ArrayList(count);
            for (i = 0; i < count; ++i) {
                this._fields.add(null);
            }
            for (i = 0; i < count; ++i) {
                this._fields.set(i, new FieldInfo(di, this._constantPool));
            }
        }
    }

    protected void readMethods(PositionDataInputStream di) throws IOException, ClassFormatError {
        int count = di.readShort();
        if (0 != count) {
            int i;
            this._methods = new ArrayList(count);
            for (i = 0; i < count; ++i) {
                this._methods.add(null);
            }
            for (i = 0; i < count; ++i) {
                this._methods.set(i, new MethodInfo(di, this._constantPool));
            }
        }
    }

    protected void readAttributes(PositionDataInputStream di) throws IOException, ClassFormatError {
        int count = di.readShort();
        if (0 != count) {
            int i;
            this._attributes = new ArrayList(count);
            for (i = 0; i < count; ++i) {
                this._attributes.add(null);
            }
            for (i = 0; i < count; ++i) {
                this._attributes.set(i, AAttributeInfo.read(di, this._constantPool));
            }
        }
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        dos.writeInt(-889275714);
        dos.writeShort(this._minorVersion);
        dos.writeShort(this._majorVersion);
        dos.writeShort(this._constantPool.size());
        for (APoolInfo cpi : this._constantPool) {
            if (null == cpi) continue;
            cpi.write(dos);
        }
        dos.writeShort(this._classAccessFlags);
        dos.writeShort(this._constantPool.indexOf(this._thisClass));
        if ("java/lang/Object".equals(this._thisClass.getName().toString())) {
            dos.writeShort(0);
        } else {
            dos.writeShort(this._constantPool.indexOf(this._superClass));
        }
        dos.writeShort(this._interfaces.size());
        for (ClassPoolInfo intrf : this._interfaces) {
            dos.writeShort(this._constantPool.indexOf(intrf));
        }
        dos.writeShort(this._fields.size());
        for (FieldInfo field : this._fields) {
            field.write(dos, this._constantPool);
        }
        dos.writeShort(this._methods.size());
        for (MethodInfo method : this._methods) {
            method.write(dos, this._constantPool);
        }
        dos.writeShort(this._attributes.size());
        for (AAttributeInfo attr : this._attributes) {
            attr.write(dos);
        }
    }

    public String getThisClassName() {
        return ClassFileTools.getClassName(this._thisClass.getName().toString());
    }

    public String getSuperClassName() {
        if (null != this._superClass) {
            return ClassFileTools.getClassName(this._superClass.getName().toString());
        }
        return "";
    }

    public String toString() {
        return "Class File (Version " + this._majorVersion + '.' + this._minorVersion + ") for class " + this._thisClass.getName();
    }

    public String toStringVerbose() {
        return this.toStringVerbose(true, true);
    }

    public String toStringVerbose(boolean lineNumbers, boolean PCs) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String thisClassName = this.getThisClassName();
        String superClassName = this.getSuperClassName();
        String packageName = null;
        if (0 < thisClassName.indexOf(46)) {
            packageName = thisClassName.substring(0, thisClassName.lastIndexOf(46));
            thisClassName = thisClassName.substring(thisClassName.lastIndexOf(46) + 1);
            pw.println("\npackage " + packageName);
        }
        pw.print(ClassFileTools.getAccessString(this._classAccessFlags) + "class " + thisClassName + (!"".equals(superClassName) ? " extends " + superClassName : ""));
        if (0 != this._interfaces.size()) {
            pw.print(" implements ");
            boolean first = true;
            for (ClassPoolInfo intrf : this._interfaces) {
                if (first) {
                    first = false;
                } else {
                    pw.print(", ");
                }
                pw.print(ClassFileTools.getClassName(intrf.getName().toString()));
            }
        }
        pw.println("\n\nConstant Pool: " + this._constantPool.size() + " items");
        int i = 0;
        for (APoolInfo cpi : this._constantPool) {
            pw.println('#' + String.format("%5d", i++) + ": " + cpi.toStringVerbose());
        }
        Set<String> classesUsed = ClassFileTools.getClassNamesUsed(this);
        pw.print("\nUsed Classes: " + classesUsed.size() + '\n');
        for (String s : classesUsed) {
            pw.println(s);
        }
        pw.println("\nAttributes: " + this._attributes.size());
        i = 0;
        for (AAttributeInfo attr : this._attributes) {
            pw.println("    Attribute " + (i++ + 1) + ": " + attr);
        }
        pw.println("\nFields: " + this._fields.size());
        for (FieldInfo field : this._fields) {
            pw.println("    " + field.toString(this._constantPool));
        }
        pw.println("\nMethods: " + this._methods.size());
        for (MethodInfo method : this._methods) {
            pw.println("    " + method.toString(this._constantPool, lineNumbers, PCs));
        }
        pw.println();
        return sw.toString();
    }

    public APoolInfo getConstantPoolItem(int index) {
        assert (index <= 65535);
        if (0 >= index || index > this._constantPool.size() - 1) {
            return null;
        }
        APoolInfo cp = (APoolInfo)this._constantPool.get(index);
        cp.reindex();
        return cp;
    }

    public int[] addConstantPoolItems(final APoolInfo[] items) {
        int j;
        final int[] indices = new int[items.length];
        int jv = 0;
        while (jv < items.length) {
            j = jv++;
            items[j].execute(new AValueReferencePoolInfoVisitor<Object, Object>(){

                @Override
                public Object refCase(APoolInfo host, Object o) {
                    return null;
                }

                @Override
                public Object emptyCase(EmptyPoolInfo host, Object o) {
                    return null;
                }

                @Override
                public Object valueCase(APoolInfo host, Object o) {
                    indices[j] = 0;
                    APoolInfo newArg = host.inPool(ClassFile.this._constantPool);
                    if (null != newArg) {
                        indices[j] = ClassFile.this._constantPool.indexOf(newArg);
                    }
                    return null;
                }

                @Override
                public Object asciizCase(ASCIIPoolInfo host, Object o) {
                    return this.utfCase(host, o);
                }

                @Override
                public Object unicodeCase(UnicodePoolInfo host, Object o) {
                    return this.utfCase(host, o);
                }

                private Object utfCase(AUTFPoolInfo utfHost, Object o) {
                    indices[j] = 0;
                    final AUTFPoolInfo newArg = (AUTFPoolInfo)utfHost.inPool(ClassFile.this._constantPool);
                    if (null != newArg) {
                        indices[j] = ClassFile.this._constantPool.indexOf(newArg);
                        for (APoolInfo cpi : items) {
                            cpi.execute(new AValueReferencePoolInfoVisitor<Object, Object>(){

                                @Override
                                public Object refCase(APoolInfo host, Object o) {
                                    return null;
                                }

                                @Override
                                public Object emptyCase(EmptyPoolInfo host, Object o) {
                                    return null;
                                }

                                @Override
                                public Object valueCase(APoolInfo host, Object o) {
                                    return null;
                                }

                                @Override
                                public Object classCase(ClassPoolInfo host, Object o) {
                                    if (host.getName() == newArg) {
                                        host.setName(newArg);
                                    }
                                    return null;
                                }

                                @Override
                                public Object stringCase(StringPoolInfo host, Object o) {
                                    if (host.getUtf() == newArg) {
                                        host.setUtf(newArg);
                                    }
                                    return null;
                                }

                                @Override
                                public Object nameAndTypeCase(NameAndTypePoolInfo host, Object o) {
                                    if (host.getName() == newArg) {
                                        host.setName(newArg);
                                    }
                                    if (host.getDescriptor() == newArg) {
                                        host.setDescriptor(newArg);
                                    }
                                    return null;
                                }
                            }, null);
                        }
                    }
                    return null;
                }
            }, null);
        }
        jv = 0;
        while (jv < items.length) {
            j = jv++;
            items[j].execute(new AValueReferencePoolInfoVisitor<Object, Object>(){

                @Override
                public Object valueCase(APoolInfo host, Object o) {
                    return null;
                }

                @Override
                public Object emptyCase(EmptyPoolInfo host, Object o) {
                    return null;
                }

                @Override
                public Object refCase(APoolInfo host, Object o) {
                    indices[j] = 0;
                    APoolInfo newArg = host.inPool(ClassFile.this._constantPool);
                    if (null != newArg) {
                        indices[j] = ClassFile.this._constantPool.indexOf(newArg);
                    }
                    return null;
                }

                @Override
                public Object classCase(ClassPoolInfo host, Object o) {
                    return this.referencedCase(host, o);
                }

                public Object nameAndTypeInfo(NameAndTypePoolInfo host, Object o) {
                    return this.referencedCase(host, o);
                }

                private Object referencedCase(APoolInfo referencedHost, Object o) {
                    indices[j] = 0;
                    final APoolInfo newArg = referencedHost.inPool(ClassFile.this._constantPool);
                    if (null != newArg) {
                        indices[j] = ClassFile.this._constantPool.indexOf(newArg);
                        for (APoolInfo cpi : items) {
                            cpi.execute(new AValueReferencePoolInfoVisitor<Object, Object>(){

                                @Override
                                public Object valueCase(APoolInfo host, Object o) {
                                    return null;
                                }

                                @Override
                                public Object emptyCase(EmptyPoolInfo host, Object o) {
                                    return null;
                                }

                                @Override
                                public Object refCase(APoolInfo host, Object o) {
                                    return null;
                                }

                                @Override
                                public Object fieldCase(FieldPoolInfo host, Object o) {
                                    return this.classNameTypeCase(host, o);
                                }

                                @Override
                                public Object methodCase(MethodPoolInfo host, Object o) {
                                    return this.classNameTypeCase(host, o);
                                }

                                @Override
                                public Object interfaceMethodCase(InterfaceMethodPoolInfo host, Object o) {
                                    return this.classNameTypeCase(host, o);
                                }

                                public Object classNameTypeCase(AClassNameTypePoolInfo host, Object o) {
                                    if (host.getClassInfo() == newArg) {
                                        host.setClassInfo((ClassPoolInfo)newArg);
                                    }
                                    if (host.getNameAndType() == newArg) {
                                        host.setNameAndType((NameAndTypePoolInfo)newArg);
                                    }
                                    return null;
                                }
                            }, null);
                        }
                    }
                    return null;
                }
            }, null);
        }
        for (int i = 0; i < items.length; ++i) {
            if (0 != indices[i]) continue;
            this._constantPool.add(items[i]);
            items[i].execute(new NoOpPoolInfoVisitor<Object, Object>(){

                @Override
                public Object longCase(LongPoolInfo host, Object o) {
                    ClassFile.this._constantPool.add(EmptyPoolInfo.singleton());
                    return null;
                }

                @Override
                public Object doubleCase(DoublePoolInfo host, Object o) {
                    ClassFile.this._constantPool.add(EmptyPoolInfo.singleton());
                    return null;
                }
            }, null);
            indices[i] = this._constantPool.indexOf(items[i]);
            assert (indices[i] <= 65535);
        }
        return indices;
    }

    public void addAttribute(AAttributeInfo newAttribute) {
        this._attributes.add(newAttribute);
    }

    public AAttributeInfo getAttribute(String name) {
        if (0 == this._attributes.size()) {
            return null;
        }
        for (AAttributeInfo attr : this._attributes) {
            if (0 != name.compareTo(attr.getName().toString())) continue;
            return attr;
        }
        return null;
    }

    public short getMinorVersion() {
        return this._minorVersion;
    }

    public void setMinorVersion(short minorVersion) {
        this._minorVersion = minorVersion;
    }

    public short getMajorVersion() {
        return this._majorVersion;
    }

    public void setMajorVersion(short majorVersion) {
        this._majorVersion = majorVersion;
    }

    public short getClassAccessFlags() {
        return this._classAccessFlags;
    }

    public void setClassAccessFlags(short classAccessFlags) {
        this._classAccessFlags = classAccessFlags;
    }

    public ClassPoolInfo getSuperClass() {
        return this._superClass;
    }

    public void setSuperClass(ClassPoolInfo cpi) {
        this._superClass = cpi;
    }

    public ClassPoolInfo getThisClass() {
        return this._thisClass;
    }

    public void setThisClass(ClassPoolInfo cpi) {
        this._thisClass = cpi;
    }

    public ArrayList<ClassPoolInfo> getInterfaces() {
        return this._interfaces;
    }

    public ArrayList<FieldInfo> getFields() {
        return this._fields;
    }

    public ArrayList<MethodInfo> getMethods() {
        return this._methods;
    }

    public ArrayList<AAttributeInfo> getAttributes() {
        return this._attributes;
    }

    public ConstantPool getConstantPool() {
        return this._constantPool;
    }

    public int addMethodToConstantPool(String className, String methodName, String methodDescriptor) {
        ConstantPool cp = this.getConstantPool();
        AUTFPoolInfo monitorClassName = new ASCIIPoolInfo(className, cp);
        int[] l = this.addConstantPoolItems(new APoolInfo[]{monitorClassName});
        monitorClassName = this.getConstantPoolItem(l[0]).execute(CheckUTFVisitor.singleton(), null);
        ClassPoolInfo monitorClass = new ClassPoolInfo(monitorClassName, cp);
        l = this.addConstantPoolItems(new APoolInfo[]{monitorClass});
        monitorClass = this.getConstantPoolItem(l[0]).execute(CheckClassVisitor.singleton(), null);
        AUTFPoolInfo methodNameInfo = new ASCIIPoolInfo(methodName, cp);
        l = this.addConstantPoolItems(new APoolInfo[]{methodNameInfo});
        methodNameInfo = this.getConstantPoolItem(l[0]).execute(CheckUTFVisitor.singleton(), null);
        AUTFPoolInfo methodTypeName = new ASCIIPoolInfo(methodDescriptor, cp);
        l = this.addConstantPoolItems(new APoolInfo[]{methodTypeName});
        methodTypeName = this.getConstantPoolItem(l[0]).execute(CheckUTFVisitor.singleton(), null);
        NameAndTypePoolInfo methodNaT = new NameAndTypePoolInfo(methodNameInfo, methodTypeName, cp);
        l = this.addConstantPoolItems(new APoolInfo[]{methodNaT});
        methodNaT = this.getConstantPoolItem(l[0]).execute(CheckNameAndTypeVisitor.singleton(), null);
        MethodPoolInfo method = new MethodPoolInfo(monitorClass, methodNaT, cp);
        l = this.addConstantPoolItems(new APoolInfo[]{method});
        method = this.getConstantPoolItem(l[0]).execute(CheckMethodVisitor.singleton(), null);
        return l[0];
    }

    public int addLongToConstantPool(long value) {
        LongPoolInfo syncBlockCodeLong = new LongPoolInfo(value, this._constantPool);
        int[] l = this.addConstantPoolItems(new APoolInfo[]{syncBlockCodeLong});
        syncBlockCodeLong = this.getConstantPoolItem(l[0]).execute(CheckLongVisitor.singleton(), null);
        return l[0];
    }

    public int addField(String className, String fieldName, String fieldDescriptor, boolean addToFields, short accessFlags) {
        ConstantPool cp = this.getConstantPool();
        AUTFPoolInfo fieldClassName = new ASCIIPoolInfo(className, cp);
        int[] l = this.addConstantPoolItems(new APoolInfo[]{fieldClassName});
        fieldClassName = this.getConstantPoolItem(l[0]).execute(CheckUTFVisitor.singleton(), null);
        ClassPoolInfo fieldClass = new ClassPoolInfo(fieldClassName, cp);
        l = this.addConstantPoolItems(new APoolInfo[]{fieldClass});
        fieldClass = this.getConstantPoolItem(l[0]).execute(CheckClassVisitor.singleton(), null);
        AUTFPoolInfo fieldNameInfo = new ASCIIPoolInfo(fieldName, cp);
        l = this.addConstantPoolItems(new APoolInfo[]{fieldNameInfo});
        fieldNameInfo = this.getConstantPoolItem(l[0]).execute(CheckUTFVisitor.singleton(), null);
        AUTFPoolInfo fieldTypeName = new ASCIIPoolInfo(fieldDescriptor, cp);
        l = this.addConstantPoolItems(new APoolInfo[]{fieldTypeName});
        fieldTypeName = this.getConstantPoolItem(l[0]).execute(CheckUTFVisitor.singleton(), null);
        NameAndTypePoolInfo fieldNaT = new NameAndTypePoolInfo(fieldNameInfo, fieldTypeName, cp);
        l = this.addConstantPoolItems(new APoolInfo[]{fieldNaT});
        fieldNaT = this.getConstantPoolItem(l[0]).execute(CheckNameAndTypeVisitor.singleton(), null);
        FieldPoolInfo field = new FieldPoolInfo(fieldClass, fieldNaT, cp);
        l = this.addConstantPoolItems(new APoolInfo[]{field});
        field = this.getConstantPoolItem(l[0]).execute(new ADefaultPoolInfoVisitor<FieldPoolInfo, Object>(){

            @Override
            public FieldPoolInfo defaultCase(APoolInfo host, Object param) {
                throw new ClassFormatError("Info is of type " + host.getClass().getName() + ", needs to be FieldPoolInfo");
            }

            @Override
            public FieldPoolInfo fieldCase(FieldPoolInfo host, Object param) {
                return host;
            }
        }, null);
        if (addToFields) {
            FieldInfo fi = new FieldInfo(accessFlags, fieldNameInfo, fieldTypeName, new SourceFileAttributeInfo[0]);
            this.getFields().add(fi);
        }
        return l[0];
    }

    public int findMethodInConstantPool(String className, String methodName, String methodDescriptor) {
        ConstantPool cp = this.getConstantPool();
        AUTFPoolInfo monitorClassName = new ASCIIPoolInfo(className, cp);
        APoolInfo newArg = (AUTFPoolInfo)monitorClassName.inPool(cp);
        if (null == newArg) {
            return 0;
        }
        monitorClassName = newArg.execute(CheckUTFVisitor.singleton(), null);
        ClassPoolInfo monitorClass = new ClassPoolInfo(monitorClassName, cp);
        if (null == (newArg = monitorClass.inPool(cp))) {
            return 0;
        }
        monitorClass = newArg.execute(CheckClassVisitor.singleton(), null);
        AUTFPoolInfo methodNameInfo = new ASCIIPoolInfo(methodName, cp);
        newArg = methodNameInfo.inPool(cp);
        if (null == newArg) {
            return 0;
        }
        methodNameInfo = newArg.execute(CheckUTFVisitor.singleton(), null);
        AUTFPoolInfo methodTypeName = new ASCIIPoolInfo(methodDescriptor, cp);
        newArg = methodTypeName.inPool(cp);
        if (null == newArg) {
            return 0;
        }
        methodTypeName = newArg.execute(CheckUTFVisitor.singleton(), null);
        NameAndTypePoolInfo methodNaT = new NameAndTypePoolInfo(methodNameInfo, methodTypeName, cp);
        if (null == (newArg = methodNaT.inPool(cp))) {
            return 0;
        }
        methodNaT = newArg.execute(CheckNameAndTypeVisitor.singleton(), null);
        MethodPoolInfo method = new MethodPoolInfo(monitorClass, methodNaT, cp);
        if (null == (newArg = method.inPool(cp))) {
            return 0;
        }
        method = newArg.execute(CheckMethodVisitor.singleton(), null);
        return cp.indexOf(method);
    }
}

