/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements SourceInfo.Wrapper {
    private final Map<String, Object> properties;
    private SourceInfo sourceInfo;

    protected Node(SourceInfo si) {
        assert (si != null);
        this.sourceInfo = si;
        this.properties = new HashMap<String, Object>();
    }

    @Override
    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(SourceInfo si) {
        assert (si != null);
        this.sourceInfo = si;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        if (!this.properties.containsKey(name)) {
            throw new IllegalStateException("Property '" + name + "' is not initialized");
        }
        return this.properties.get(name);
    }

    public Set<String> getProperties() {
        return this.properties.keySet();
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public void archiveProperties(String prefix) {
        HashMap<String, Object> newProps = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : this.properties.entrySet()) {
            newProps.put(prefix + e.getKey(), e.getValue());
        }
        this.properties.clear();
        this.properties.putAll(newProps);
    }

    public abstract <T> T acceptVisitor(Visitor<T> var1);
}

