/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import edu.rice.cs.util.JoinInputStream;
import java.io.IOException;
import java.io.InputStream;

class ReaderThread
extends Thread {
    volatile int available;
    volatile int pos;
    byte[] buffer;
    InputStream stream;
    IOException exception;
    JoinInputStream monitor;

    ReaderThread(JoinInputStream monitor, InputStream stream, int bufferSize) {
        this.stream = stream;
        this.monitor = monitor;
        this.buffer = new byte[bufferSize];
        this.available = 0;
        this.pos = 0;
        this.exception = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        while (true) {
            int len;
            try {
                len = this.stream.read(this.buffer);
            }
            catch (IOException ex) {
                this.exception = ex;
                len = -1;
            }
            JoinInputStream ex = this.monitor;
            synchronized (ex) {
                this.available = len;
                this.pos = 0;
                this.monitor.notify();
                if (len < 0) {
                    try {
                        this.stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    --this.monitor.openedStreams;
                    return;
                }
            }
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException ex2) {
                    return;
                }
            } while (this.available != 0);
        }
    }

    synchronized int read() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        int ch = this.buffer[this.pos] & 0xFF;
        if (++this.pos == this.available) {
            this.available = 0;
            this.notify();
        }
        return ch;
    }

    synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.available - this.pos <= len) {
            len = this.available - this.pos;
            this.available = 0;
            this.notify();
        }
        System.arraycopy(this.buffer, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    void close() throws IOException {
        this.interrupt();
        this.stream.close();
    }
}

