/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.io;

import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.debug.ThreadSnapshot;
import edu.rice.cs.plt.io.ChecksumOutputStream;
import edu.rice.cs.plt.io.FilePredicate;
import edu.rice.cs.plt.io.MessageDigestOutputStream;
import edu.rice.cs.plt.io.SerializableException;
import edu.rice.cs.plt.io.VoidOutputStream;
import edu.rice.cs.plt.io.WrappedDirectInputStream;
import edu.rice.cs.plt.io.WrappedDirectReader;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.ReadOnlyIterator;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.LazyThunk;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.recur.RecursionStack;
import edu.rice.cs.plt.reflect.ReflectUtil;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.plt.tuple.Null;
import edu.rice.cs.plt.tuple.Octet;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.plt.tuple.Quad;
import edu.rice.cs.plt.tuple.Quint;
import edu.rice.cs.plt.tuple.Septet;
import edu.rice.cs.plt.tuple.Sextet;
import edu.rice.cs.plt.tuple.Triple;
import edu.rice.cs.plt.tuple.Tuple;
import edu.rice.cs.plt.tuple.Wrapper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOUtil {
    public static final File WORKING_DIRECTORY = IOUtil.attemptAbsoluteFile(new File(System.getProperty("user.dir", "")));
    public static final Lambda<String, File> FILE_FACTORY = new FileFactory();
    private static final Lambda<File, File> GET_ABSOLUTE_FILE = new Lambda<File, File>(){

        @Override
        public File value(File arg) {
            return arg.getAbsoluteFile();
        }
    };
    private static final Lambda<File, File> ATTEMPT_ABSOLUTE_FILE = new Lambda<File, File>(){

        @Override
        public File value(File arg) {
            return IOUtil.attemptAbsoluteFile(arg);
        }
    };
    private static final Lambda<File, File> GET_CANONICAL_FILE = new Lambda<File, File>(){

        @Override
        public File value(File arg) {
            try {
                return arg.getCanonicalFile();
            }
            catch (IOException e) {
                throw new WrappedException(e);
            }
        }
    };
    private static final Lambda<File, File> ATTEMPT_CANONICAL_FILE = new Lambda<File, File>(){

        @Override
        public File value(File arg) {
            return IOUtil.attemptAbsoluteFile(arg);
        }
    };
    private static final Lambda<File, File> CANONICAL_CASE = new Lambda<File, File>(){

        @Override
        public File value(File arg) {
            return IOUtil.canonicalCase(arg);
        }
    };
    private static final Thunk<List<Closeable>> TO_CLOSE = LazyThunk.make(new Thunk<List<Closeable>>(){

        @Override
        public List<Closeable> value() {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    for (Closeable c : (List)TO_CLOSE.value()) {
                        IOUtil.attemptClose(c);
                    }
                }
            });
            return new LinkedList<Closeable>();
        }
    });
    public static final FilePredicate IS_FILE = new IsFileFilePredicate();
    public static final FilePredicate IS_DIRECTORY = new IsDirectoryFilePredicate();
    public static final FilePredicate ALWAYS_ACCEPT = IOUtil.asFilePredicate(LambdaUtil.TRUE);
    public static final FilePredicate ALWAYS_REJECT = IOUtil.asFilePredicate(LambdaUtil.FALSE);
    private static final LinkedList<PrintStream> SYSTEM_OUT_STACK = new LinkedList();
    private static final LinkedList<PrintStream> SYSTEM_ERR_STACK = new LinkedList();
    private static final LinkedList<InputStream> SYSTEM_IN_STACK = new LinkedList();
    private static final Set<Class<?>> SERIALIZABLE_CLASSES = new HashSet();

    private IOUtil() {
    }

    public static File attemptAbsoluteFile(File f) {
        try {
            return f.getAbsoluteFile();
        }
        catch (SecurityException e) {
            return f;
        }
    }

    public static SizedIterable<File> getAbsoluteFiles(Iterable<? extends File> files) {
        return IterUtil.mapSnapshot(files, GET_ABSOLUTE_FILE);
    }

    public static SizedIterable<File> attemptAbsoluteFiles(Iterable<? extends File> files) {
        return IterUtil.mapSnapshot(files, ATTEMPT_ABSOLUTE_FILE);
    }

    public static File attemptCanonicalFile(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return IOUtil.attemptAbsoluteFile(f);
        }
        catch (SecurityException e) {
            return IOUtil.attemptAbsoluteFile(f);
        }
    }

    public static SizedIterable<File> getCanonicalFiles(Iterable<? extends File> files) throws IOException {
        try {
            return IterUtil.mapSnapshot(files, GET_CANONICAL_FILE);
        }
        catch (WrappedException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public static SizedIterable<File> attemptCanonicalFiles(Iterable<? extends File> files) {
        return IterUtil.mapSnapshot(files, ATTEMPT_CANONICAL_FILE);
    }

    public static boolean attemptCanRead(File f) {
        try {
            return f.canRead();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptCanWrite(File f) {
        try {
            return f.canWrite();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptExists(File f) {
        try {
            return f.exists();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptIsDirectory(File f) {
        try {
            return f.isDirectory();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptIsFile(File f) {
        try {
            return f.isFile();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptIsHidden(File f) {
        try {
            return f.isHidden();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static long attemptLastModified(File f) {
        try {
            return f.lastModified();
        }
        catch (SecurityException e) {
            return 0L;
        }
    }

    public static long attemptLength(File f) {
        try {
            return f.length();
        }
        catch (SecurityException e) {
            return 0L;
        }
    }

    public static boolean attemptCreateNewFile(File f) {
        try {
            return f.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptDelete(File f) {
        try {
            return f.delete();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static void attemptDeleteOnExit(File f) {
        try {
            f.deleteOnExit();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static File[] attemptListFiles(File f) {
        try {
            return f.listFiles();
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static File[] attemptListFiles(File f, FileFilter filter) {
        try {
            return f.listFiles(filter);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static File[] attemptListFiles(File f, Predicate<? super File> filter) {
        return IOUtil.attemptListFiles(f, (FileFilter)IOUtil.asFilePredicate(filter));
    }

    public static File[] attemptListFiles(File f, FilePredicate filter) {
        return IOUtil.attemptListFiles(f, (FileFilter)filter);
    }

    public static SizedIterable<File> attemptListFilesAsIterable(File f) {
        File[] result = IOUtil.attemptListFiles(f);
        if (result == null) {
            return IterUtil.empty();
        }
        return IterUtil.asIterable(result);
    }

    public static SizedIterable<File> attemptListFilesAsIterable(File f, FileFilter filter) {
        File[] result = IOUtil.attemptListFiles(f, filter);
        if (result == null) {
            return IterUtil.empty();
        }
        return IterUtil.asIterable(result);
    }

    public static SizedIterable<File> attemptListFilesAsIterable(File f, Predicate<? super File> filter) {
        return IOUtil.attemptListFilesAsIterable(f, (FileFilter)IOUtil.asFilePredicate(filter));
    }

    public static SizedIterable<File> attemptListFilesAsIterable(File f, FilePredicate filter) {
        return IOUtil.attemptListFilesAsIterable(f, (FileFilter)filter);
    }

    public static boolean attemptMkdir(File f) {
        try {
            return f.mkdir();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptMkdirs(File f) {
        try {
            return f.mkdirs();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptRenameTo(File f, File dest) {
        try {
            return f.renameTo(dest);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptMove(File f, File dest) {
        IOUtil.attemptDelete(dest);
        return IOUtil.attemptRenameTo(f, dest);
    }

    public static boolean attemptSetLastModified(File f, long time) {
        try {
            return f.setLastModified(time);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptSetReadOnly(File f) {
        try {
            return f.setReadOnly();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static File canonicalCase(File f) {
        File lowered = new File(f.getPath().toLowerCase());
        if (f.equals(lowered)) {
            return lowered;
        }
        return f;
    }

    public static SizedIterable<File> canonicalCases(Iterable<? extends File> files) {
        return IterUtil.mapSnapshot(files, CANONICAL_CASE);
    }

    public static boolean isMember(File f, File ancestor) {
        for (File parent = f; parent != null; parent = parent.getParentFile()) {
            if (!parent.equals(ancestor)) continue;
            return true;
        }
        return false;
    }

    public static SizedIterable<File> fullPath(File f) {
        AbstractIterable result = IterUtil.singleton(f);
        for (File parent = f.getParentFile(); parent != null; parent = parent.getParentFile()) {
            result = IterUtil.compose(parent, result);
        }
        return result;
    }

    public static boolean deleteRecursively(File f) {
        return IOUtil.deleteRecursively(f, new RecursionStack<File>(Wrapper.factory()));
    }

    private static boolean deleteRecursively(File f, final RecursionStack<File> stack) {
        if (f.isDirectory()) {
            try {
                final File canonicalF = f.getCanonicalFile();
                Runnable deleteMembers = new Runnable(){

                    public void run() {
                        for (File child : IOUtil.attemptListFilesAsIterable(canonicalF)) {
                            IOUtil.deleteRecursively(child, stack);
                        }
                    }
                };
                stack.run(deleteMembers, canonicalF);
            }
            catch (IOException e) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return IOUtil.attemptDelete(f);
    }

    public static void deleteOnExitRecursively(File f) {
        IOUtil.deleteOnExitRecursively(f, new RecursionStack<File>(Wrapper.factory()));
    }

    private static void deleteOnExitRecursively(File f, final RecursionStack<File> stack) {
        IOUtil.attemptDeleteOnExit(f);
        if (f.isDirectory()) {
            try {
                final File canonicalF = f.getCanonicalFile();
                Runnable markMembers = new Runnable(){

                    public void run() {
                        for (File child : IOUtil.attemptListFilesAsIterable(canonicalF)) {
                            IOUtil.deleteOnExitRecursively(child, stack);
                        }
                    }
                };
                stack.run(markMembers, canonicalF);
            }
            catch (IOException e) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public static SizedIterable<File> listFilesRecursively(File f) {
        return IOUtil.listFilesRecursively(f, ALWAYS_ACCEPT, ALWAYS_ACCEPT);
    }

    public static SizedIterable<File> listFilesRecursively(File f, FileFilter filter) {
        return IOUtil.listFilesRecursively(f, filter, (FileFilter)ALWAYS_ACCEPT);
    }

    public static SizedIterable<File> listFilesRecursively(File f, Predicate<? super File> filter) {
        return IOUtil.listFilesRecursively(f, IOUtil.asFilePredicate(filter), ALWAYS_ACCEPT);
    }

    public static SizedIterable<File> listFilesRecursively(File f, FilePredicate filter) {
        return IOUtil.listFilesRecursively(f, filter, ALWAYS_ACCEPT);
    }

    public static SizedIterable<File> listFilesRecursively(File f, FileFilter filter, FileFilter recursionFilter) {
        return IOUtil.listFilesRecursively(f, filter, recursionFilter, new RecursionStack<File>(Wrapper.factory()));
    }

    public static SizedIterable<File> listFilesRecursively(File f, Predicate<? super File> filter, Predicate<? super File> recursionFilter) {
        return IOUtil.listFilesRecursively(f, IOUtil.asFilePredicate(filter), IOUtil.asFilePredicate(recursionFilter), new RecursionStack<File>(Wrapper.factory()));
    }

    public static SizedIterable<File> listFilesRecursively(File f, FilePredicate filter, FilePredicate recursionFilter) {
        return IOUtil.listFilesRecursively(f, filter, recursionFilter, new RecursionStack<File>(Wrapper.factory()));
    }

    private static SizedIterable<File> listFilesRecursively(final File f, final FileFilter filter, final FileFilter recursionFilter, final RecursionStack<File> stack) {
        AbstractIterable result;
        AbstractIterable abstractIterable = result = filter.accept(f) ? IterUtil.singleton(f) : IterUtil.empty();
        if (f.isDirectory() && recursionFilter.accept(f)) {
            Thunk<Iterable<File>> getMembers = new Thunk<Iterable<File>>(){

                @Override
                public Iterable<File> value() {
                    AbstractIterable dirFiles = IterUtil.empty();
                    for (File child : IOUtil.attemptListFilesAsIterable(f)) {
                        dirFiles = IterUtil.compose(dirFiles, IOUtil.listFilesRecursively(child, filter, recursionFilter, stack));
                    }
                    return dirFiles;
                }
            };
            try {
                result = IterUtil.compose(result, (Iterable)stack.apply(getMembers, IterUtil.empty(), f.getCanonicalFile()));
            }
            catch (IOException e) {
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        try {
            byte[] byArray = IOUtil.toByteArray(input);
            return byArray;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer toStringBuffer(File file) throws IOException {
        FileReader reader = new FileReader(file);
        try {
            StringBuffer stringBuffer = IOUtil.toStringBuffer(reader);
            return stringBuffer;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(File file) throws IOException {
        FileReader reader = new FileReader(file);
        try {
            String string = IOUtil.toString(reader);
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static Iterator<String> readLines(File file) throws IOException {
        FileReader reader = new FileReader(file);
        return IOUtil.readLines(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int adler32Hash(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        try {
            int n = IOUtil.adler32Hash(input);
            return n;
        }
        finally {
            ((InputStream)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int crc32Hash(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        try {
            int n = IOUtil.crc32Hash(input);
            return n;
        }
        finally {
            ((InputStream)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] md5Hash(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        try {
            byte[] byArray = IOUtil.md5Hash(input);
            return byArray;
        }
        finally {
            ((InputStream)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sha1Hash(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        try {
            byte[] byArray = IOUtil.sha1Hash(input);
            return byArray;
        }
        finally {
            ((InputStream)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sha256Hash(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        try {
            byte[] byArray = IOUtil.sha256Hash(input);
            return byArray;
        }
        finally {
            ((InputStream)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest) throws IOException {
        FileInputStream in = new FileInputStream(source);
        try {
            FileOutputStream out = new FileOutputStream(dest);
            try {
                IOUtil.copyInputStream(in, out);
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest, byte[] buffer) throws IOException {
        FileInputStream in = new FileInputStream(source);
        try {
            FileOutputStream out = new FileOutputStream(dest);
            try {
                IOUtil.copyInputStream(in, out, buffer);
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    public static void writeStringToFile(File file, String text) throws IOException {
        IOUtil.writeStringToFile(file, text, false);
    }

    public static boolean attemptWriteStringToFile(File file, String text) {
        try {
            IOUtil.writeStringToFile(file, text);
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String text, boolean append) throws IOException {
        FileWriter writer = new FileWriter(file, append);
        try {
            writer.write(text);
        }
        finally {
            writer.close();
        }
    }

    public static boolean attemptWriteStringToFile(File file, String text, boolean append) {
        try {
            IOUtil.writeStringToFile(file, text, append);
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static File createAndMarkTempFile(String prefix, String suffix) throws IOException {
        return IOUtil.createAndMarkTempFile(prefix, suffix, null);
    }

    public static File createAndMarkTempFile(String prefix, String suffix, File location) throws IOException {
        File result = File.createTempFile(prefix, suffix, location);
        IOUtil.attemptDeleteOnExit(result);
        return result;
    }

    public static File createAndMarkTempDirectory(String prefix, String suffix) throws IOException {
        return IOUtil.createAndMarkTempDirectory(prefix, suffix, null);
    }

    public static File createAndMarkTempDirectory(String prefix, String suffix, File location) throws IOException {
        File result = File.createTempFile(prefix, suffix, location);
        boolean success = result.delete();
        boolean bl = success = success && result.mkdir();
        if (!success) {
            throw new IOException("Attempt to create directory failed");
        }
        IOUtil.attemptDeleteOnExit(result);
        return result;
    }

    public static SizedIterable<File> parsePath(String path) {
        String[] filenames = path.split(TextUtil.regexEscape(File.pathSeparator));
        return IterUtil.mapSnapshot(IterUtil.asIterable(filenames), FILE_FACTORY);
    }

    public static String pathToString(Iterable<? extends File> path) {
        return IterUtil.toString(path, "", File.pathSeparator, "");
    }

    public static int copyReader(Reader source, Writer dest) throws IOException {
        return WrappedDirectReader.makeDirect(source).readAll(dest);
    }

    public static int copyReader(Reader source, Writer dest, char[] buffer) throws IOException {
        return WrappedDirectReader.makeDirect(source).readAll(dest, buffer);
    }

    public static int writeFromReader(Reader source, Writer dest, int chars) throws IOException {
        return WrappedDirectReader.makeDirect(source).read(dest, chars);
    }

    public static int writeFromReader(Reader source, Writer dest, int chars, char[] buffer) throws IOException {
        return WrappedDirectReader.makeDirect(source).read(dest, chars, buffer);
    }

    public static int copyInputStream(InputStream source, OutputStream dest) throws IOException {
        return WrappedDirectInputStream.makeDirect(source).readAll(dest);
    }

    public static int copyInputStream(InputStream source, OutputStream dest, byte[] buffer) throws IOException {
        return WrappedDirectInputStream.makeDirect(source).readAll(dest, buffer);
    }

    public static int writeFromInputStream(InputStream source, OutputStream dest, int bytes) throws IOException {
        return WrappedDirectInputStream.makeDirect(source).read(dest, bytes);
    }

    public static int writeFromInputStream(InputStream source, OutputStream dest, int bytes, byte[] buffer) throws IOException {
        return WrappedDirectInputStream.makeDirect(source).read(dest, bytes, buffer);
    }

    protected static int doCopyReader(Reader r, Writer w, char[] buffer) throws IOException {
        if (buffer.length == 0) {
            throw new IllegalArgumentException();
        }
        int charsRead = r.read(buffer);
        if (charsRead == -1) {
            return -1;
        }
        int totalCharsRead = 0;
        do {
            if ((totalCharsRead += charsRead) < 0) {
                totalCharsRead = Integer.MAX_VALUE;
            }
            w.write(buffer, 0, charsRead);
        } while ((charsRead = r.read(buffer)) != -1);
        return totalCharsRead;
    }

    protected static int doCopyInputStream(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        if (buffer.length == 0) {
            throw new IllegalArgumentException();
        }
        int charsRead = in.read(buffer);
        if (charsRead == -1) {
            return -1;
        }
        int totalCharsRead = 0;
        do {
            if ((totalCharsRead += charsRead) < 0) {
                totalCharsRead = Integer.MAX_VALUE;
            }
            out.write(buffer, 0, charsRead);
        } while ((charsRead = in.read(buffer)) != -1);
        return totalCharsRead;
    }

    protected static int doWriteFromReader(Reader r, Writer w, int chars, char[] buffer) throws IOException {
        if (buffer.length == 0 && chars > 0) {
            throw new IllegalArgumentException();
        }
        int charsRead = r.read(buffer, 0, chars < buffer.length ? chars : buffer.length);
        if (charsRead == -1) {
            return -1;
        }
        int totalCharsRead = 0;
        while (chars > 0 && charsRead > 0) {
            totalCharsRead += charsRead;
            w.write(buffer, 0, charsRead);
            if ((chars -= charsRead) <= 0) continue;
            charsRead = r.read(buffer, 0, chars < buffer.length ? chars : buffer.length);
        }
        return totalCharsRead;
    }

    protected static int doWriteFromInputStream(InputStream in, OutputStream out, int bytes, byte[] buffer) throws IOException {
        if (buffer.length == 0 && bytes > 0) {
            throw new IllegalArgumentException();
        }
        int bytesRead = in.read(buffer, 0, bytes < buffer.length ? bytes : buffer.length);
        if (bytesRead == -1) {
            return -1;
        }
        int totalBytesRead = 0;
        while (bytes > 0 && bytesRead > 0) {
            totalBytesRead += bytesRead;
            out.write(buffer, 0, bytesRead);
            if ((bytes -= bytesRead) <= 0) continue;
            bytesRead = in.read(buffer, 0, bytes < buffer.length ? bytes : buffer.length);
        }
        return totalBytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream stream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtil.copyInputStream(stream, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer toStringBuffer(Reader r) throws IOException {
        StringWriter out = new StringWriter();
        try {
            IOUtil.copyReader(r, out);
            StringBuffer stringBuffer = out.getBuffer();
            return stringBuffer;
        }
        finally {
            out.close();
        }
    }

    public static String toString(Reader r) throws IOException {
        return IOUtil.toStringBuffer(r).toString();
    }

    public static Iterator<String> readLines(Reader r) throws IOException {
        final BufferedReader br = IOUtil.asBuffered(r);
        final String firstLine = br.readLine();
        if (firstLine == null) {
            br.close();
        }
        return new ReadOnlyIterator<String>(){
            String lookahead;
            {
                this.lookahead = firstLine;
            }

            @Override
            public boolean hasNext() {
                return this.lookahead != null;
            }

            @Override
            public String next() {
                if (this.lookahead == null) {
                    throw new NoSuchElementException();
                }
                try {
                    String result = this.lookahead;
                    this.lookahead = br.readLine();
                    if (this.lookahead == null) {
                        br.close();
                    }
                    return result;
                }
                catch (IOException e) {
                    throw new WrappedException(e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int adler32Hash(InputStream stream) throws IOException {
        ChecksumOutputStream out = ChecksumOutputStream.makeAdler32();
        try {
            IOUtil.copyInputStream(stream, out);
            int n = (int)out.getValue();
            return n;
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int crc32Hash(InputStream stream) throws IOException {
        ChecksumOutputStream out = ChecksumOutputStream.makeCRC32();
        try {
            IOUtil.copyInputStream(stream, out);
            int n = (int)out.getValue();
            return n;
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] md5Hash(InputStream stream) throws IOException {
        MessageDigestOutputStream out = MessageDigestOutputStream.makeMD5();
        try {
            IOUtil.copyInputStream(stream, out);
            byte[] byArray = out.digest();
            return byArray;
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sha1Hash(InputStream stream) throws IOException {
        MessageDigestOutputStream out = MessageDigestOutputStream.makeSHA1();
        try {
            IOUtil.copyInputStream(stream, out);
            byte[] byArray = out.digest();
            return byArray;
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sha256Hash(InputStream stream) throws IOException {
        MessageDigestOutputStream out = MessageDigestOutputStream.makeSHA256();
        try {
            IOUtil.copyInputStream(stream, out);
            byte[] byArray = out.digest();
            return byArray;
        }
        finally {
            out.close();
        }
    }

    public static BufferedReader asBuffered(Reader r) {
        if (r instanceof BufferedReader) {
            return (BufferedReader)r;
        }
        return new BufferedReader(r);
    }

    public static BufferedWriter asBuffered(Writer w) {
        if (w instanceof BufferedWriter) {
            return (BufferedWriter)w;
        }
        return new BufferedWriter(w);
    }

    public static BufferedInputStream asBuffered(InputStream in) {
        if (in instanceof BufferedInputStream) {
            return (BufferedInputStream)in;
        }
        return new BufferedInputStream(in);
    }

    public static BufferedOutputStream asBuffered(OutputStream out) {
        if (out instanceof BufferedOutputStream) {
            return (BufferedOutputStream)out;
        }
        return new BufferedOutputStream(out);
    }

    public static void closeOnExit(Closeable c) {
        TO_CLOSE.value().add(c);
    }

    public static void attemptClose(Closeable c) {
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static FilePredicate asFilePredicate(Predicate<? super File> p) {
        return new PredicateFilePredicate(p);
    }

    public static FilePredicate asFilePredicate(FileFilter filter) {
        return new FileFilterFilePredicate(filter);
    }

    public static FilePredicate regexFilePredicate(String regex) {
        return new RegexFilePredicate(regex);
    }

    public static FilePredicate regexFilePredicate(Pattern regex) {
        return new RegexFilePredicate(regex);
    }

    public static FilePredicate regexCanonicalCaseFilePredicate(String regex) {
        return new RegexCanonicalCaseFilePredicate(regex);
    }

    public static FilePredicate extensionFilePredicate(String extension) {
        return new RegexCanonicalCaseFilePredicate(".*\\." + IOUtil.canonicalCase(new File(extension)).getName());
    }

    public static FilePredicate sameNameFilePredicate(String name) {
        return new SamePathFilePredicate(new File(name));
    }

    public static FilePredicate samePathFilePredicate(File path) {
        return new SamePathFilePredicate(path);
    }

    public static FilePredicate sameAttributesFilePredicate(File f) throws FileNotFoundException {
        return new SameAttributesFilePredicate(f);
    }

    public static FilePredicate sameContentsFilePredicate(File f) throws IOException {
        return new SameContentsFilePredicate(f);
    }

    public static FilePredicate and(FileFilter ... filters) {
        return new AndFilePredicate(IterUtil.asIterable(filters));
    }

    public static FilePredicate and(Iterable<? extends FileFilter> filters) {
        return new AndFilePredicate(filters);
    }

    public static FilePredicate or(FileFilter ... filters) {
        return new OrFilePredicate(IterUtil.asIterable(filters));
    }

    public static FilePredicate or(Iterable<? extends FileFilter> filters) {
        return new OrFilePredicate(filters);
    }

    public static FilePredicate negate(FileFilter filter) {
        return new NegationFilePredicate(filter);
    }

    public static FilePredicate fileKey(File f) throws IOException {
        return IOUtil.and(IOUtil.samePathFilePredicate(IOUtil.attemptAbsoluteFile(f)), IOUtil.sameAttributesFilePredicate(f), IOUtil.sameContentsFilePredicate(f));
    }

    public static void replaceSystemOut(OutputStream substitute) {
        SYSTEM_OUT_STACK.addLast(System.out);
        if (substitute instanceof PrintStream) {
            System.setOut((PrintStream)substitute);
        } else {
            System.setOut(new PrintStream(substitute));
        }
    }

    public static void ignoreSystemOut() {
        IOUtil.replaceSystemOut(VoidOutputStream.INSTANCE);
    }

    public static void revertSystemOut() {
        if (SYSTEM_OUT_STACK.isEmpty()) {
            DebugUtil.error.logStack("Unbalanced call to revertSystemOut");
        } else {
            System.setOut(SYSTEM_OUT_STACK.removeLast());
        }
    }

    public static void replaceSystemErr(OutputStream substitute) {
        SYSTEM_ERR_STACK.addLast(System.err);
        if (substitute instanceof PrintStream) {
            System.setErr((PrintStream)substitute);
        } else {
            System.setErr(new PrintStream(substitute));
        }
    }

    public static void ignoreSystemErr() {
        IOUtil.replaceSystemErr(VoidOutputStream.INSTANCE);
    }

    public static void revertSystemErr() {
        if (SYSTEM_ERR_STACK.isEmpty()) {
            DebugUtil.error.logStack("Unbalanced call to revertSystemErr");
        } else {
            System.setErr(SYSTEM_ERR_STACK.removeLast());
        }
    }

    public static void replaceSystemIn(InputStream substitute) {
        SYSTEM_IN_STACK.addLast(System.in);
        System.setIn(substitute);
    }

    public static void revertSystemIn() {
        if (SYSTEM_IN_STACK.isEmpty()) {
            DebugUtil.error.logStack("Unbalanced call to revertSystemIn");
        } else {
            System.setIn(SYSTEM_IN_STACK.removeLast());
        }
    }

    public static Object ensureSerializable(Object obj) {
        if (obj == null) {
            return null;
        }
        if (SERIALIZABLE_CLASSES.contains(obj.getClass())) {
            return obj;
        }
        if (obj instanceof Object[]) {
            return IOUtil.ensureSerializable((Object[])obj);
        }
        if (obj instanceof Iterable) {
            return IOUtil.ensureSerializable((Iterable)obj);
        }
        if (obj instanceof Throwable) {
            return IOUtil.ensureSerializable((Throwable)obj);
        }
        if (obj instanceof Tuple) {
            return IOUtil.ensureSerializable((Tuple)obj);
        }
        return obj.toString();
    }

    public static Object[] ensureSerializable(Object[] arr) {
        Class<?> base = ReflectUtil.arrayBaseClass(arr.getClass());
        if (SERIALIZABLE_CLASSES.contains(base) && Modifier.isFinal(base.getModifiers())) {
            return arr;
        }
        boolean keep = true;
        Object[] result = new Object[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            result[i] = IOUtil.ensureSerializable(arr[i]);
            keep &= result[i] == arr[i];
        }
        return keep ? arr : result;
    }

    public static Iterable<?> ensureSerializable(Iterable<?> iter2) {
        if (IterUtil.isInfinite(iter2)) {
            iter2 = IterUtil.compose(IterUtil.truncate(iter2, 8), "...");
        }
        boolean keep = iter2.getClass().equals(ArrayList.class);
        ArrayList result = new ArrayList();
        for (Object elt : iter2) {
            Object safe;
            keep &= elt == (safe = IOUtil.ensureSerializable(elt));
            result.add(safe);
        }
        return keep ? iter2 : result;
    }

    public static Throwable ensureSerializable(Throwable t) {
        Throwable safeCause;
        Throwable throwable = safeCause = t.getCause() == null ? null : IOUtil.ensureSerializable(t.getCause());
        if (t.getCause() == safeCause && IOUtil.isSafeThrowableClass(t.getClass())) {
            return t;
        }
        return new SerializableException(t, safeCause);
    }

    public static Exception ensureSerializable(Exception e) {
        Throwable safeCause;
        Throwable throwable = safeCause = e.getCause() == null ? null : IOUtil.ensureSerializable(e.getCause());
        if (e.getCause() == safeCause && IOUtil.isSafeThrowableClass(e.getClass())) {
            return e;
        }
        return new SerializableException(e, safeCause);
    }

    public static RuntimeException ensureSerializable(RuntimeException e) {
        Throwable safeCause;
        Throwable throwable = safeCause = e.getCause() == null ? null : IOUtil.ensureSerializable(e.getCause());
        if (e.getCause() == safeCause && IOUtil.isSafeThrowableClass(e.getClass())) {
            return e;
        }
        return new SerializableException(e, safeCause);
    }

    private static boolean isSafeThrowableClass(Class<?> c) {
        try {
            if (!c.getMethod("getCause", new Class[0]).getDeclaringClass().equals(Throwable.class)) {
                return false;
            }
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
        for (Class<?> parent = c; !parent.equals(Throwable.class) && parent != null; parent = parent.getSuperclass()) {
            for (Field f : parent.getDeclaredFields()) {
                Class<?> fType = f.getType();
                if (fType.isPrimitive() || SERIALIZABLE_CLASSES.contains(f.getType())) continue;
                return false;
            }
        }
        return true;
    }

    public static Tuple ensureSerializable(Tuple t) {
        if (t instanceof Null) {
            return t;
        }
        if (t instanceof Wrapper) {
            return IOUtil.ensureSerializable((Wrapper)t);
        }
        if (t instanceof Pair) {
            return IOUtil.ensureSerializable((Pair)t);
        }
        if (t instanceof Triple) {
            return IOUtil.ensureSerializable((Triple)t);
        }
        if (t instanceof Quad) {
            return IOUtil.ensureSerializable((Quad)t);
        }
        if (t instanceof Quint) {
            return IOUtil.ensureSerializable((Quint)t);
        }
        if (t instanceof Sextet) {
            return IOUtil.ensureSerializable((Sextet)t);
        }
        if (t instanceof Septet) {
            return IOUtil.ensureSerializable((Septet)t);
        }
        if (t instanceof Octet) {
            return IOUtil.ensureSerializable((Octet)t);
        }
        throw new IllegalArgumentException("Unrecognized tuple type: " + t.getClass().getName());
    }

    public static Option<?> ensureSerializable(Option<?> opt) {
        if (opt instanceof Null) {
            return opt;
        }
        if (opt instanceof Wrapper) {
            return IOUtil.ensureSerializable((Wrapper)opt);
        }
        throw new IllegalArgumentException("Unrecognized option type: " + opt.getClass().getName());
    }

    public static Wrapper<?> ensureSerializable(Wrapper<?> w) {
        Object safeVal = IOUtil.ensureSerializable(w.value());
        if (w.getClass().equals(Wrapper.class) && w.value() == safeVal) {
            return w;
        }
        return Wrapper.make(safeVal);
    }

    public static Pair<?, ?> ensureSerializable(Pair<?, ?> p) {
        Object safeFirst = IOUtil.ensureSerializable(p.first());
        Object safeSecond = IOUtil.ensureSerializable(p.second());
        if (p.getClass().equals(Pair.class) && p.first() == safeFirst && p.second() == safeSecond) {
            return p;
        }
        return Pair.make(safeFirst, safeSecond);
    }

    public static Triple<?, ?, ?> ensureSerializable(Triple<?, ?, ?> t) {
        Object safeFirst = IOUtil.ensureSerializable(t.first());
        Object safeSecond = IOUtil.ensureSerializable(t.second());
        Object safeThird = IOUtil.ensureSerializable(t.third());
        if (t.getClass().equals(Triple.class) && t.first() == safeFirst && t.second() == safeSecond && t.third() == safeThird) {
            return t;
        }
        return Triple.make(safeFirst, safeSecond, safeThird);
    }

    public static Quad<?, ?, ?, ?> ensureSerializable(Quad<?, ?, ?, ?> q) {
        Object safeFirst = IOUtil.ensureSerializable(q.first());
        Object safeSecond = IOUtil.ensureSerializable(q.second());
        Object safeThird = IOUtil.ensureSerializable(q.third());
        Object safeFourth = IOUtil.ensureSerializable(q.fourth());
        if (q.getClass().equals(Quad.class) && q.first() == safeFirst && q.second() == safeSecond && q.third() == safeThird && q.fourth() == safeFourth) {
            return q;
        }
        return Quad.make(safeFirst, safeSecond, safeThird, safeFourth);
    }

    public static Quint<?, ?, ?, ?, ?> ensureSerializable(Quint<?, ?, ?, ?, ?> q) {
        Object safeFirst = IOUtil.ensureSerializable(q.first());
        Object safeSecond = IOUtil.ensureSerializable(q.second());
        Object safeThird = IOUtil.ensureSerializable(q.third());
        Object safeFourth = IOUtil.ensureSerializable(q.fourth());
        Object safeFifth = IOUtil.ensureSerializable(q.fifth());
        if (q.getClass().equals(Quint.class) && q.first() == safeFirst && q.second() == safeSecond && q.third() == safeThird && q.fourth() == safeFourth && q.fifth() == safeFifth) {
            return q;
        }
        return Quint.make(safeFirst, safeSecond, safeThird, safeFourth, safeFifth);
    }

    public static Sextet<?, ?, ?, ?, ?, ?> ensureSerializable(Sextet<?, ?, ?, ?, ?, ?> s) {
        Object safeFirst = IOUtil.ensureSerializable(s.first());
        Object safeSecond = IOUtil.ensureSerializable(s.second());
        Object safeThird = IOUtil.ensureSerializable(s.third());
        Object safeFourth = IOUtil.ensureSerializable(s.fourth());
        Object safeFifth = IOUtil.ensureSerializable(s.fifth());
        Object safeSixth = IOUtil.ensureSerializable(s.sixth());
        if (s.getClass().equals(Quint.class) && s.first() == safeFirst && s.second() == safeSecond && s.third() == safeThird && s.fourth() == safeFourth && s.fifth() == safeFifth && s.sixth() == safeSixth) {
            return s;
        }
        return Sextet.make(safeFirst, safeSecond, safeThird, safeFourth, safeFifth, safeSixth);
    }

    public static Septet<?, ?, ?, ?, ?, ?, ?> ensureSerializable(Septet<?, ?, ?, ?, ?, ?, ?> s) {
        Object safeFirst = IOUtil.ensureSerializable(s.first());
        Object safeSecond = IOUtil.ensureSerializable(s.second());
        Object safeThird = IOUtil.ensureSerializable(s.third());
        Object safeFourth = IOUtil.ensureSerializable(s.fourth());
        Object safeFifth = IOUtil.ensureSerializable(s.fifth());
        Object safeSixth = IOUtil.ensureSerializable(s.sixth());
        Object safeSeventh = IOUtil.ensureSerializable(s.seventh());
        if (s.getClass().equals(Quint.class) && s.first() == safeFirst && s.second() == safeSecond && s.third() == safeThird && s.fourth() == safeFourth && s.fifth() == safeFifth && s.sixth() == safeSixth && s.seventh() == safeSeventh) {
            return s;
        }
        return Septet.make(safeFirst, safeSecond, safeThird, safeFourth, safeFifth, safeSixth, safeSeventh);
    }

    public static Octet<?, ?, ?, ?, ?, ?, ?, ?> ensureSerializable(Octet<?, ?, ?, ?, ?, ?, ?, ?> o) {
        Object safeFirst = IOUtil.ensureSerializable(o.first());
        Object safeSecond = IOUtil.ensureSerializable(o.second());
        Object safeThird = IOUtil.ensureSerializable(o.third());
        Object safeFourth = IOUtil.ensureSerializable(o.fourth());
        Object safeFifth = IOUtil.ensureSerializable(o.fifth());
        Object safeSixth = IOUtil.ensureSerializable(o.sixth());
        Object safeSeventh = IOUtil.ensureSerializable(o.seventh());
        Object safeEighth = IOUtil.ensureSerializable(o.eighth());
        if (o.getClass().equals(Quint.class) && o.first() == safeFirst && o.second() == safeSecond && o.third() == safeThird && o.fourth() == safeFourth && o.fifth() == safeFifth && o.sixth() == safeSixth && o.seventh() == safeSeventh && o.eighth() == safeEighth) {
            return o;
        }
        return Octet.make(safeFirst, safeSecond, safeThird, safeFourth, safeFifth, safeSixth, safeSeventh, safeEighth);
    }

    static {
        SERIALIZABLE_CLASSES.add(String.class);
        SERIALIZABLE_CLASSES.add(Boolean.class);
        SERIALIZABLE_CLASSES.add(Character.class);
        SERIALIZABLE_CLASSES.add(Byte.class);
        SERIALIZABLE_CLASSES.add(Short.class);
        SERIALIZABLE_CLASSES.add(Integer.class);
        SERIALIZABLE_CLASSES.add(Long.class);
        SERIALIZABLE_CLASSES.add(Float.class);
        SERIALIZABLE_CLASSES.add(Double.class);
        SERIALIZABLE_CLASSES.add(Date.class);
        SERIALIZABLE_CLASSES.add(File.class);
        SERIALIZABLE_CLASSES.add(StackTraceElement.class);
        SERIALIZABLE_CLASSES.add(ThreadSnapshot.class);
        SERIALIZABLE_CLASSES.add(Null.class);
        SERIALIZABLE_CLASSES.add(boolean[].class);
        SERIALIZABLE_CLASSES.add(char[].class);
        SERIALIZABLE_CLASSES.add(byte[].class);
        SERIALIZABLE_CLASSES.add(short[].class);
        SERIALIZABLE_CLASSES.add(int[].class);
        SERIALIZABLE_CLASSES.add(long[].class);
        SERIALIZABLE_CLASSES.add(float[].class);
        SERIALIZABLE_CLASSES.add(double[].class);
    }

    private static final class NegationFilePredicate
    implements FilePredicate,
    Serializable {
        private final FileFilter _filter;

        public NegationFilePredicate(FileFilter filter) {
            this._filter = filter;
        }

        public boolean accept(File f) {
            return !this._filter.accept(f);
        }

        public boolean contains(File f) {
            return !this._filter.accept(f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OrFilePredicate
    implements FilePredicate,
    Serializable {
        private final Iterable<? extends FileFilter> _filters;

        public OrFilePredicate(Iterable<? extends FileFilter> filters) {
            this._filters = filters;
        }

        @Override
        public boolean accept(File f) {
            for (FileFilter fileFilter : this._filters) {
                if (!fileFilter.accept(f)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(File f) {
            return this.accept(f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AndFilePredicate
    implements FilePredicate,
    Serializable {
        private final Iterable<? extends FileFilter> _filters;

        public AndFilePredicate(Iterable<? extends FileFilter> filters) {
            this._filters = filters;
        }

        @Override
        public boolean accept(File f) {
            for (FileFilter fileFilter : this._filters) {
                if (fileFilter.accept(f)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(File f) {
            return this.accept(f);
        }
    }

    private static final class IsDirectoryFilePredicate
    implements FilePredicate,
    Serializable {
        private IsDirectoryFilePredicate() {
        }

        public boolean accept(File f) {
            return IOUtil.attemptIsDirectory(f);
        }

        public boolean contains(File f) {
            return IOUtil.attemptIsDirectory(f);
        }
    }

    private static final class IsFileFilePredicate
    implements FilePredicate,
    Serializable {
        private IsFileFilePredicate() {
        }

        public boolean accept(File f) {
            return IOUtil.attemptIsFile(f);
        }

        public boolean contains(File f) {
            return IOUtil.attemptIsFile(f);
        }
    }

    private static final class SameContentsFilePredicate
    implements FilePredicate,
    Serializable {
        private final long _length;
        private final int _hash;

        public SameContentsFilePredicate(File f) throws IOException {
            this._length = IOUtil.attemptLength(f);
            this._hash = IOUtil.crc32Hash(f);
        }

        public boolean accept(File f) {
            long fLength = IOUtil.attemptLength(f);
            if (fLength > 0L && this._length > 0L && fLength != this._length) {
                return false;
            }
            try {
                return this._hash == IOUtil.crc32Hash(f);
            }
            catch (IOException e) {
                return false;
            }
        }

        public boolean contains(File f) {
            return this.accept(f);
        }
    }

    private static final class SameAttributesFilePredicate
    implements FilePredicate,
    Serializable {
        private final long _lastModified;
        private final long _length;
        private final boolean _canRead;
        private final boolean _canWrite;

        public SameAttributesFilePredicate(File f) throws FileNotFoundException {
            try {
                if (!f.isFile()) {
                    throw new FileNotFoundException(f + " is not a valid file");
                }
                this._lastModified = f.lastModified();
                if (this._lastModified == 0L) {
                    throw new FileNotFoundException("Can't get valid modification date for " + f);
                }
                this._length = f.length();
                this._canRead = f.canRead();
                this._canWrite = f.canWrite();
            }
            catch (SecurityException e) {
                throw new FileNotFoundException(e.getMessage());
            }
        }

        public boolean accept(File f) {
            try {
                return f.isFile() && f.lastModified() == this._lastModified && f.length() == this._length && f.canRead() == this._canRead && f.canWrite() == this._canWrite;
            }
            catch (SecurityException e) {
                return false;
            }
        }

        public boolean contains(File f) {
            return this.accept(f);
        }
    }

    private static final class SamePathFilePredicate
    implements FilePredicate,
    Serializable {
        private final File _f;

        public SamePathFilePredicate(File f) {
            this._f = IOUtil.canonicalCase(f);
        }

        public boolean accept(File f) {
            File candidate = IOUtil.canonicalCase(IOUtil.attemptAbsoluteFile(f));
            for (File compareTo = this._f; compareTo != null; compareTo = compareTo.getParentFile()) {
                if (candidate == null || !compareTo.getName().equals(candidate.getName())) {
                    return false;
                }
                candidate = candidate.getParentFile();
            }
            return true;
        }

        public boolean contains(File f) {
            return this.accept(f);
        }
    }

    private static final class RegexCanonicalCaseFilePredicate
    implements FilePredicate,
    Serializable {
        private final Pattern _regex;

        public RegexCanonicalCaseFilePredicate(String regex) {
            this._regex = Pattern.compile(regex);
        }

        public RegexCanonicalCaseFilePredicate(Pattern regex) {
            this._regex = regex;
        }

        public boolean accept(File f) {
            return this._regex.matcher(IOUtil.canonicalCase(f).getName()).matches();
        }

        public boolean contains(File f) {
            return this._regex.matcher(IOUtil.canonicalCase(f).getName()).matches();
        }
    }

    private static final class RegexFilePredicate
    implements FilePredicate,
    Serializable {
        private final Pattern _regex;

        public RegexFilePredicate(String regex) {
            this._regex = Pattern.compile(regex);
        }

        public RegexFilePredicate(Pattern regex) {
            this._regex = regex;
        }

        public boolean accept(File f) {
            return this._regex.matcher(f.getName()).matches();
        }

        public boolean contains(File f) {
            return this._regex.matcher(f.getName()).matches();
        }
    }

    private static final class FileFilterFilePredicate
    implements FilePredicate,
    Serializable {
        private final FileFilter _filter;

        public FileFilterFilePredicate(FileFilter filter) {
            this._filter = filter;
        }

        public boolean accept(File f) {
            return this._filter.accept(f);
        }

        public boolean contains(File f) {
            return this._filter.accept(f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PredicateFilePredicate
    implements FilePredicate,
    Serializable {
        private final Predicate<? super File> _p;

        public PredicateFilePredicate(Predicate<? super File> p) {
            this._p = p;
        }

        @Override
        public boolean accept(File f) {
            return this._p.contains(f);
        }

        @Override
        public boolean contains(File f) {
            return this._p.contains(f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileFactory
    implements Lambda<String, File>,
    Serializable {
        private FileFactory() {
        }

        @Override
        public File value(String name) {
            return new File(name);
        }
    }
}

