/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.AbstractRelation;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.collect.LazyRelationIndex;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.tuple.Pair;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnindexedRelation<T1, T2>
extends AbstractRelation<T1, T2> {
    private final Set<Pair<T1, T2>> _pairs;

    public UnindexedRelation() {
        this(CollectUtil.hashSetFactory());
    }

    public UnindexedRelation(Thunk<Set<Pair<T1, T2>>> setFactory) {
        this._pairs = setFactory.value();
    }

    @Override
    public boolean isEmpty() {
        return this._pairs.isEmpty();
    }

    @Override
    public int size() {
        return this._pairs.size();
    }

    @Override
    public boolean hasFixedSize() {
        return false;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean contains(T1 first, T2 second) {
        return this._pairs.contains(new Pair<T1, T2>(first, second));
    }

    @Override
    public boolean contains(Object obj) {
        return this._pairs.contains(obj);
    }

    @Override
    public Iterator<Pair<T1, T2>> iterator() {
        return this._pairs.iterator();
    }

    @Override
    public boolean add(T1 first, T2 second) {
        return this._pairs.add(new Pair<T1, T2>(first, second));
    }

    @Override
    public boolean remove(T1 first, T2 second) {
        return this._pairs.remove(new Pair<T1, T2>(first, second));
    }

    @Override
    public void clear() {
        this._pairs.clear();
    }

    @Override
    public PredicateSet<T1> firstSet() {
        return new LazyRelationIndex(this._pairs).keys();
    }

    @Override
    public PredicateSet<T2> matchFirst(T1 first) {
        return new LazyRelationIndex(this._pairs).match(first);
    }

    @Override
    public PredicateSet<T2> secondSet() {
        return new LazyRelationIndex(IterUtil.map(this._pairs, Pair.inverter())).keys();
    }

    @Override
    public PredicateSet<T1> matchSecond(T2 second) {
        return new LazyRelationIndex(IterUtil.map(this._pairs, Pair.inverter())).match(second);
    }

    public static <T1, T2> UnindexedRelation<T1, T2> makeHashBased() {
        return new UnindexedRelation<T1, T2>(CollectUtil.<Pair<T1, T2>>hashSetFactory());
    }

    public static <T1, T2> UnindexedRelation<T1, T2> makeLinkedHashBased() {
        return new UnindexedRelation<T1, T2>(CollectUtil.<Pair<T1, T2>>linkedHashSetFactory());
    }

    public static <T1 extends Comparable<? super T1>, T2 extends Comparable<? super T2>> UnindexedRelation<T1, T2> makeTreeBased() {
        return new UnindexedRelation(CollectUtil.treeSetFactory(Pair.comparator()));
    }
}

